/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.userinfo;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequestEntityConverter;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Deprecated
public class CustomUserTypesOAuth2UserService
implements OAuth2UserService<OAuth2UserRequest, OAuth2User> {
    private static final String INVALID_USER_INFO_RESPONSE_ERROR_CODE = "invalid_user_info_response";
    private final Map<String, Class<? extends OAuth2User>> customUserTypes;
    private Converter<OAuth2UserRequest, RequestEntity<?>> requestEntityConverter = new OAuth2UserRequestEntityConverter();
    private RestOperations restOperations;

    public CustomUserTypesOAuth2UserService(Map<String, Class<? extends OAuth2User>> customUserTypes) {
        Assert.notEmpty(customUserTypes, (String)"customUserTypes cannot be empty");
        this.customUserTypes = Collections.unmodifiableMap(new LinkedHashMap<String, Class<? extends OAuth2User>>(customUserTypes));
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        this.restOperations = restTemplate;
    }

    @Override
    public OAuth2User loadUser(OAuth2UserRequest userRequest) throws OAuth2AuthenticationException {
        Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
        String registrationId = userRequest.getClientRegistration().getRegistrationId();
        Class<? extends OAuth2User> customUserType = this.customUserTypes.get(registrationId);
        if (customUserType == null) {
            return null;
        }
        RequestEntity request = (RequestEntity)this.requestEntityConverter.convert((Object)userRequest);
        ResponseEntity<? extends OAuth2User> response = this.getResponse(customUserType, request);
        OAuth2User oauth2User = (OAuth2User)response.getBody();
        return oauth2User;
    }

    private ResponseEntity<? extends OAuth2User> getResponse(Class<? extends OAuth2User> customUserType, RequestEntity<?> request) {
        try {
            return this.restOperations.exchange(request, customUserType);
        }
        catch (RestClientException ex) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE, "An error occurred while attempting to retrieve the UserInfo Resource: " + ex.getMessage(), null);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString(), (Throwable)ex);
        }
    }

    public final void setRequestEntityConverter(Converter<OAuth2UserRequest, RequestEntity<?>> requestEntityConverter) {
        Assert.notNull(requestEntityConverter, (String)"requestEntityConverter cannot be null");
        this.requestEntityConverter = requestEntityConverter;
    }

    public final void setRestOperations(RestOperations restOperations) {
        Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
        this.restOperations = restOperations;
    }
}

