/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.UnreachableFilterChainException;
import org.springframework.security.web.access.AuthorizationManagerWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.PathPatternRequestTransformer;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.jaasapi.JaasApiIntegrationFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.util.ClassUtils;

public class DefaultFilterChainValidator
implements FilterChainProxy.FilterChainValidator {
    private static final boolean USING_ACCESS = ClassUtils.isPresent((String)"org.springframework.security.access.SecurityConfig", null);
    private static final Authentication TEST = new TestingAuthenticationToken((Object)"", (Object)"", Collections.emptyList());
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer requestTransformer = new PathPatternRequestTransformer();

    public void validate(FilterChainProxy fcp) {
        for (SecurityFilterChain filterChain : fcp.getFilterChains()) {
            this.checkLoginPageIsntProtected(fcp, filterChain.getFilters());
            this.checkFilterStack(filterChain.getFilters());
        }
        this.checkPathOrder(new ArrayList<SecurityFilterChain>(fcp.getFilterChains()));
        this.checkForDuplicateMatchers(new ArrayList<SecurityFilterChain>(fcp.getFilterChains()));
        this.checkAuthorizationFilters(new ArrayList<SecurityFilterChain>(fcp.getFilterChains()));
    }

    private void checkPathOrder(List<SecurityFilterChain> filterChains) {
        Iterator<SecurityFilterChain> chains = filterChains.iterator();
        while (chains.hasNext()) {
            DefaultSecurityFilterChain securityFilterChain;
            SecurityFilterChain securityFilterChain2 = chains.next();
            if (!(securityFilterChain2 instanceof DefaultSecurityFilterChain) || !AnyRequestMatcher.INSTANCE.equals((securityFilterChain = (DefaultSecurityFilterChain)securityFilterChain2).getRequestMatcher()) || !chains.hasNext()) continue;
            throw new UnreachableFilterChainException("A universal match pattern ('/**') is defined  before other patterns in the filter chain, causing them to be ignored. Please check the ordering in your <security:http> namespace or FilterChainProxy bean configuration", (SecurityFilterChain)securityFilterChain, chains.next());
        }
    }

    private void checkForDuplicateMatchers(List<SecurityFilterChain> chains) {
        DefaultSecurityFilterChain filterChain = null;
        for (SecurityFilterChain chain : chains) {
            DefaultSecurityFilterChain defaultChain;
            if (filterChain != null && chain instanceof DefaultSecurityFilterChain && (defaultChain = (DefaultSecurityFilterChain)chain).getRequestMatcher().equals(filterChain.getRequestMatcher())) {
                throw new UnreachableFilterChainException("The FilterChainProxy contains two filter chains using the matcher " + String.valueOf(defaultChain.getRequestMatcher()) + ". If you are using multiple <http> namespace elements, you must use a 'pattern' attribute to define the request patterns to which they apply.", (SecurityFilterChain)defaultChain, chain);
            }
            if (!(chain instanceof DefaultSecurityFilterChain)) continue;
            filterChain = defaultChain = (DefaultSecurityFilterChain)chain;
        }
    }

    private void checkAuthorizationFilters(List<SecurityFilterChain> chains) {
        Filter authorizationFilter = null;
        Filter filterSecurityInterceptor = null;
        for (SecurityFilterChain chain : chains) {
            for (Filter filter : chain.getFilters()) {
                if (filter instanceof AuthorizationFilter) {
                    authorizationFilter = filter;
                }
                if (!USING_ACCESS || !AccessComponents.isFilterSecurityInterceptor(filter)) continue;
                filterSecurityInterceptor = filter;
            }
            if (authorizationFilter != null && filterSecurityInterceptor != null) {
                this.logger.warn((Object)"It is not recommended to use authorizeRequests or FilterSecurityInterceptor in the configuration. Please only use authorizeHttpRequests");
            }
            if (filterSecurityInterceptor != null) {
                this.logger.warn((Object)"Usage of authorizeRequests and FilterSecurityInterceptor are deprecated. Please use authorizeHttpRequests in the configuration");
            }
            authorizationFilter = null;
            filterSecurityInterceptor = null;
        }
    }

    private static <F extends Filter> F getFilter(Class<F> type, List<Filter> filters) {
        for (Filter f : filters) {
            if (!type.isAssignableFrom(f.getClass())) continue;
            return (F)f;
        }
        return null;
    }

    private void checkFilterStack(List<Filter> filters) {
        this.checkForDuplicates(SecurityContextPersistenceFilter.class, filters);
        this.checkForDuplicates(UsernamePasswordAuthenticationFilter.class, filters);
        this.checkForDuplicates(SessionManagementFilter.class, filters);
        this.checkForDuplicates(BasicAuthenticationFilter.class, filters);
        this.checkForDuplicates(SecurityContextHolderAwareRequestFilter.class, filters);
        this.checkForDuplicates(JaasApiIntegrationFilter.class, filters);
        this.checkForDuplicates(ExceptionTranslationFilter.class, filters);
        if (USING_ACCESS) {
            this.checkForDuplicates(AccessComponents.getFilterSecurityInterceptorClass(), filters);
        }
        this.checkForDuplicates(AuthorizationFilter.class, filters);
    }

    private void checkForDuplicates(Class<? extends Filter> clazz, List<Filter> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            Filter f1 = filters.get(i);
            if (!clazz.isAssignableFrom(f1.getClass())) continue;
            for (int j = i + 1; j < filters.size(); ++j) {
                Filter f2 = filters.get(j);
                if (!clazz.isAssignableFrom(f2.getClass())) continue;
                this.logger.warn((Object)("Possible error: Filters at position " + i + " and " + j + " are both instances of " + clazz.getName()));
                return;
            }
        }
    }

    private void checkLoginPageIsntProtected(FilterChainProxy fcp, List<Filter> filterStack) {
        ExceptionTranslationFilter exceptions = DefaultFilterChainValidator.getFilter(ExceptionTranslationFilter.class, filterStack);
        if (exceptions == null || !(exceptions.getAuthenticationEntryPoint() instanceof LoginUrlAuthenticationEntryPoint)) {
            return;
        }
        String loginPage = ((LoginUrlAuthenticationEntryPoint)exceptions.getAuthenticationEntryPoint()).getLoginFormUrl();
        this.logger.info((Object)("Checking whether login URL '" + loginPage + "' is accessible with your configuration"));
        FilterInvocation invocation = new FilterInvocation(loginPage, "POST");
        HttpServletRequest loginRequest = this.requestTransformer.transform(invocation.getRequest());
        List filters = null;
        try {
            filters = fcp.getFilters(loginPage);
        }
        catch (Exception ex) {
            this.logger.info((Object)"Failed to obtain filter chain information for the login page. Unable to complete check.");
        }
        if (filters == null || filters.isEmpty()) {
            this.logger.debug((Object)"Filter chain is empty for the login page");
            return;
        }
        if (DefaultFilterChainValidator.getFilter(DefaultLoginPageGeneratingFilter.class, filters) != null) {
            this.logger.debug((Object)"Default generated login page is in use");
            return;
        }
        if (this.checkLoginPageIsPublic(filters, loginRequest)) {
            return;
        }
        AnonymousAuthenticationFilter anonymous = DefaultFilterChainValidator.getFilter(AnonymousAuthenticationFilter.class, filters);
        if (anonymous == null) {
            this.logger.warn((Object)"The login page is being protected by the filter chain, but you don't appear to have anonymous authentication enabled. This is almost certainly an error.");
            return;
        }
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("key", anonymous.getPrincipal(), (Collection)anonymous.getAuthorities());
        Supplier<Boolean> check = this.deriveAnonymousCheck(filters, loginRequest, token);
        try {
            boolean allowed = check.get();
            if (!allowed) {
                this.logger.warn((Object)"Anonymous access to the login page doesn't appear to be enabled. This is almost certainly an error. Please check your configuration allows unauthenticated access to the configured login page. (Simulated access was rejected)");
            }
        }
        catch (Exception ex) {
            this.logger.info((Object)"Unable to check access to the login page to determine if anonymous access is allowed. This might be an error, but can happen under normal circumstances.", (Throwable)ex);
        }
    }

    private boolean checkLoginPageIsPublic(List<Filter> filters, HttpServletRequest loginRequest) {
        Boolean isPublic;
        if (USING_ACCESS && (isPublic = AccessComponents.checkLoginPageIsPublic(filters, loginRequest)) != null) {
            return isPublic;
        }
        AuthorizationFilter authorizationFilter = DefaultFilterChainValidator.getFilter(AuthorizationFilter.class, filters);
        if (authorizationFilter != null) {
            AuthorizationManager authorizationManager = authorizationFilter.getAuthorizationManager();
            try {
                AuthorizationResult result = authorizationManager.authorize(() -> TEST, (Object)loginRequest);
                return result != null && result.isGranted();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private Supplier<Boolean> deriveAnonymousCheck(List<Filter> filters, HttpServletRequest loginRequest, AnonymousAuthenticationToken token) {
        Supplier<Boolean> check;
        if (USING_ACCESS && (check = AccessComponents.getAnonymousCheck(filters, loginRequest, token)) != null) {
            return check;
        }
        AuthorizationFilter authorizationFilter = DefaultFilterChainValidator.getFilter(AuthorizationFilter.class, filters);
        if (authorizationFilter != null) {
            return () -> {
                AuthorizationManager authorizationManager = authorizationFilter.getAuthorizationManager();
                AuthorizationResult result = authorizationManager.authorize(() -> token, (Object)loginRequest);
                return result != null && result.isGranted();
            };
        }
        return () -> true;
    }

    private static final class AccessComponents {
        private static final Log logger = LogFactory.getLog(DefaultFilterChainValidator.class);

        private AccessComponents() {
        }

        private static boolean isFilterSecurityInterceptor(Filter filter) {
            return filter instanceof FilterSecurityInterceptor;
        }

        private static Class<FilterSecurityInterceptor> getFilterSecurityInterceptorClass() {
            return FilterSecurityInterceptor.class;
        }

        private static Boolean checkLoginPageIsPublic(List<Filter> filters, HttpServletRequest loginRequest) {
            FilterSecurityInterceptor authorizationInterceptor = DefaultFilterChainValidator.getFilter(FilterSecurityInterceptor.class, filters);
            if (authorizationInterceptor == null) {
                return null;
            }
            FilterInvocationSecurityMetadataSource fids = authorizationInterceptor.getSecurityMetadataSource();
            Collection attributes = fids.getAttributes((Object)loginRequest);
            if (attributes == null) {
                logger.debug((Object)"No access attributes defined for login page URL");
                if (authorizationInterceptor.isRejectPublicInvocations()) {
                    logger.warn((Object)"FilterSecurityInterceptor is configured to reject public invocations. Your login page may not be accessible.");
                }
                return true;
            }
            return false;
        }

        private static Supplier<Boolean> getAnonymousCheck(List<Filter> filters, HttpServletRequest loginRequest, AnonymousAuthenticationToken token) {
            FilterSecurityInterceptor authorizationInterceptor = DefaultFilterChainValidator.getFilter(FilterSecurityInterceptor.class, filters);
            if (authorizationInterceptor == null) {
                return null;
            }
            return () -> {
                FilterInvocationSecurityMetadataSource source = authorizationInterceptor.getSecurityMetadataSource();
                Collection attributes = source.getAttributes((Object)loginRequest);
                try {
                    authorizationInterceptor.getAccessDecisionManager().decide((Authentication)token, (Object)loginRequest, attributes);
                    return true;
                }
                catch (AccessDeniedException ex) {
                    return false;
                }
            };
        }
    }
}

