/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.bind.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.web.debug.DebugFilter;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.RequestRejectedHandler;
import org.springframework.security.web.method.annotation.CsrfTokenArgumentResolver;
import org.springframework.security.web.method.annotation.CurrentSecurityContextArgumentResolver;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.web.filter.CompositeFilter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

class WebMvcSecurityConfiguration
implements WebMvcConfigurer,
ApplicationContextAware {
    private BeanResolver beanResolver;
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private AnnotationTemplateExpressionDefaults templateDefaults;

    WebMvcSecurityConfiguration() {
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        org.springframework.security.web.method.annotation.AuthenticationPrincipalArgumentResolver authenticationPrincipalResolver = new org.springframework.security.web.method.annotation.AuthenticationPrincipalArgumentResolver();
        authenticationPrincipalResolver.setBeanResolver(this.beanResolver);
        authenticationPrincipalResolver.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
        authenticationPrincipalResolver.setTemplateDefaults(this.templateDefaults);
        argumentResolvers.add((HandlerMethodArgumentResolver)authenticationPrincipalResolver);
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver());
        CurrentSecurityContextArgumentResolver currentSecurityContextArgumentResolver = new CurrentSecurityContextArgumentResolver();
        currentSecurityContextArgumentResolver.setBeanResolver(this.beanResolver);
        currentSecurityContextArgumentResolver.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
        currentSecurityContextArgumentResolver.setTemplateDefaults(this.templateDefaults);
        argumentResolvers.add((HandlerMethodArgumentResolver)currentSecurityContextArgumentResolver);
        argumentResolvers.add((HandlerMethodArgumentResolver)new CsrfTokenArgumentResolver());
    }

    @Bean
    RequestDataValueProcessor requestDataValueProcessor() {
        return new CsrfRequestDataValueProcessor();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanResolver = new BeanFactoryResolver((BeanFactory)applicationContext.getAutowireCapableBeanFactory());
        if (applicationContext.getBeanNamesForType(SecurityContextHolderStrategy.class).length == 1) {
            this.securityContextHolderStrategy = (SecurityContextHolderStrategy)applicationContext.getBean(SecurityContextHolderStrategy.class);
        }
        if (applicationContext.getBeanNamesForType(AnnotationTemplateExpressionDefaults.class).length == 1) {
            this.templateDefaults = (AnnotationTemplateExpressionDefaults)applicationContext.getBean(AnnotationTemplateExpressionDefaults.class);
        }
    }

    @Deprecated
    static class CompositeFilterChainProxy
    extends FilterChainProxy {
        private final Filter doFilterDelegate;
        private final FilterChainProxy springSecurityFilterChain;

        CompositeFilterChainProxy(List<? extends Filter> filters) {
            this.doFilterDelegate = CompositeFilterChainProxy.createDoFilterDelegate(filters);
            this.springSecurityFilterChain = CompositeFilterChainProxy.findFilterChainProxy(filters);
        }

        public void afterPropertiesSet() {
            this.springSecurityFilterChain.afterPropertiesSet();
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.doFilterDelegate.doFilter(request, response, chain);
        }

        public List<Filter> getFilters(String url) {
            return this.springSecurityFilterChain.getFilters(url);
        }

        public List<SecurityFilterChain> getFilterChains() {
            return this.springSecurityFilterChain.getFilterChains();
        }

        public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.springSecurityFilterChain.setSecurityContextHolderStrategy(securityContextHolderStrategy);
        }

        public void setFilterChainValidator(FilterChainProxy.FilterChainValidator filterChainValidator) {
            this.springSecurityFilterChain.setFilterChainValidator(filterChainValidator);
        }

        public void setFilterChainDecorator(FilterChainProxy.FilterChainDecorator filterChainDecorator) {
            this.springSecurityFilterChain.setFilterChainDecorator(filterChainDecorator);
        }

        public void setFirewall(HttpFirewall firewall) {
            this.springSecurityFilterChain.setFirewall(firewall);
        }

        public void setRequestRejectedHandler(RequestRejectedHandler requestRejectedHandler) {
            this.springSecurityFilterChain.setRequestRejectedHandler(requestRejectedHandler);
        }

        private List<? extends Filter> getFilters(HttpServletRequest request) {
            List filterChains = this.springSecurityFilterChain.getFilterChains();
            for (SecurityFilterChain chain : filterChains) {
                if (!chain.matches(request)) continue;
                return chain.getFilters();
            }
            return null;
        }

        private static Filter createDoFilterDelegate(List<? extends Filter> filters) {
            CompositeFilter delegate = new CompositeFilter();
            delegate.setFilters(filters);
            return delegate;
        }

        private static FilterChainProxy findFilterChainProxy(List<? extends Filter> filters) {
            for (Filter filter : filters) {
                if (filter instanceof FilterChainProxy) {
                    FilterChainProxy fcp = (FilterChainProxy)filter;
                    return fcp;
                }
                if (!(filter instanceof DebugFilter)) continue;
                DebugFilter debugFilter = (DebugFilter)filter;
                return debugFilter.getFilterChainProxy();
            }
            throw new IllegalStateException("Couldn't find FilterChainProxy in " + String.valueOf(filters));
        }
    }
}

