/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.opensaml.core.Version;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSaml5LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSaml5LogoutResponseValidator;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.HttpSessionLogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml5LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml5LogoutResponseResolver;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class Saml2LogoutBeanDefinitionParserUtils {
    private static final boolean USE_OPENSAML_5 = Version.getVersion().startsWith("5");
    private static final String ATT_RELYING_PARTY_REGISTRATION_REPOSITORY_REF = "relying-party-registration-repository-ref";
    private static final String ATT_LOGOUT_REQUEST_VALIDATOR_REF = "logout-request-validator-ref";
    private static final String ATT_LOGOUT_REQUEST_REPOSITORY_REF = "logout-request-repository-ref";
    private static final String ATT_LOGOUT_REQUEST_RESOLVER_REF = "logout-request-resolver-ref";
    private static final String ATT_LOGOUT_RESPONSE_RESOLVER_REF = "logout-response-resolver-ref";
    private static final String ATT_LOGOUT_RESPONSE_VALIDATOR_REF = "logout-response-validator-ref";

    private Saml2LogoutBeanDefinitionParserUtils() {
    }

    static BeanMetadataElement getRelyingPartyRegistrationRepository(Element element) {
        String relyingPartyRegistrationRepositoryRef = element.getAttribute(ATT_RELYING_PARTY_REGISTRATION_REPOSITORY_REF);
        if (StringUtils.hasText((String)relyingPartyRegistrationRepositoryRef)) {
            return new RuntimeBeanReference(relyingPartyRegistrationRepositoryRef);
        }
        return new RuntimeBeanReference(RelyingPartyRegistrationRepository.class);
    }

    static BeanMetadataElement getLogoutResponseResolver(Element element, BeanMetadataElement registrations) {
        String logoutResponseResolver = element.getAttribute(ATT_LOGOUT_RESPONSE_RESOLVER_REF);
        if (StringUtils.hasText((String)logoutResponseResolver)) {
            return new RuntimeBeanReference(logoutResponseResolver);
        }
        if (USE_OPENSAML_5) {
            return BeanDefinitionBuilder.rootBeanDefinition(OpenSaml5LogoutResponseResolver.class).addConstructorArgValue((Object)registrations).getBeanDefinition();
        }
        throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
    }

    static BeanMetadataElement getLogoutRequestValidator(Element element) {
        String logoutRequestValidator = element.getAttribute(ATT_LOGOUT_REQUEST_VALIDATOR_REF);
        if (StringUtils.hasText((String)logoutRequestValidator)) {
            return new RuntimeBeanReference(logoutRequestValidator);
        }
        if (USE_OPENSAML_5) {
            return BeanDefinitionBuilder.rootBeanDefinition(OpenSaml5LogoutRequestValidator.class).getBeanDefinition();
        }
        throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
    }

    static BeanMetadataElement getLogoutResponseValidator(Element element) {
        String logoutResponseValidator = element.getAttribute(ATT_LOGOUT_RESPONSE_VALIDATOR_REF);
        if (StringUtils.hasText((String)logoutResponseValidator)) {
            return new RuntimeBeanReference(logoutResponseValidator);
        }
        if (USE_OPENSAML_5) {
            return BeanDefinitionBuilder.rootBeanDefinition(OpenSaml5LogoutResponseValidator.class).getBeanDefinition();
        }
        throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
    }

    static BeanMetadataElement getLogoutRequestRepository(Element element) {
        String logoutRequestRepository = element.getAttribute(ATT_LOGOUT_REQUEST_REPOSITORY_REF);
        if (StringUtils.hasText((String)logoutRequestRepository)) {
            return new RuntimeBeanReference(logoutRequestRepository);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(HttpSessionLogoutRequestRepository.class).getBeanDefinition();
    }

    static BeanMetadataElement getLogoutRequestResolver(Element element, BeanMetadataElement registrations) {
        String logoutRequestResolver = element.getAttribute(ATT_LOGOUT_REQUEST_RESOLVER_REF);
        if (StringUtils.hasText((String)logoutRequestResolver)) {
            return new RuntimeBeanReference(logoutRequestResolver);
        }
        if (USE_OPENSAML_5) {
            return BeanDefinitionBuilder.rootBeanDefinition(OpenSaml5LogoutRequestResolver.class).addConstructorArgValue((Object)registrations).getBeanDefinition();
        }
        throw new IllegalArgumentException("Spring Security does not support OpenSAML " + Version.getVersion() + ". Please use OpenSAML 5");
    }
}

