/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authorization;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.config.annotation.authorization.AuthorizationManagerFactoryConfiguration;
import org.springframework.security.config.annotation.authorization.EnableMfaFiltersConfiguration;
import org.springframework.security.config.annotation.authorization.EnableMultiFactorAuthentication;

class MultiFactorAuthenticationSelector
implements ImportSelector {
    MultiFactorAuthenticationSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        Map multiFactorAuthenticationAttrs = metadata.getAnnotationAttributes(EnableMultiFactorAuthentication.class.getName());
        String[] authorities = multiFactorAuthenticationAttrs.getOrDefault("authorities", new String[0]);
        ArrayList<String> imports = new ArrayList<String>(2);
        if (authorities.length > 0) {
            imports.add(AuthorizationManagerFactoryConfiguration.class.getName());
        }
        imports.add(EnableMfaFiltersConfiguration.class.getName());
        return imports.toArray(new String[imports.size()]);
    }
}

