/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authorization;

import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthorizationManagerFactories;
import org.springframework.security.authorization.DefaultAuthorizationManagerFactory;
import org.springframework.security.config.annotation.authorization.EnableGlobalMultiFactorAuthentication;

class GlobalMultiFactorAuthenticationConfiguration
implements ImportAware {
    private String[] authorities;

    GlobalMultiFactorAuthenticationConfiguration() {
    }

    @Bean
    DefaultAuthorizationManagerFactory authorizationManagerFactory(ObjectProvider<RoleHierarchy> roleHierarchy) {
        AuthorizationManagerFactories.AdditionalRequiredFactorsBuilder builder = AuthorizationManagerFactories.multiFactor().requireFactors(this.authorities);
        return builder.build();
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map multiFactorAuthenticationAttrs = importMetadata.getAnnotationAttributes(EnableGlobalMultiFactorAuthentication.class.getName());
        this.authorities = (String[])multiFactorAuthenticationAttrs.get("authorities");
    }
}

