/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ObservationReactiveAuthorizationManager;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.MethodInvocationResult;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.Authentication;
import org.springframework.util.function.SingletonSupplier;
import reactor.core.publisher.Mono;

final class DeferringObservationReactiveAuthorizationManager<T>
implements ReactiveAuthorizationManager<T>,
MethodAuthorizationDeniedHandler {
    private final Supplier<ReactiveAuthorizationManager<T>> delegate;
    private MethodAuthorizationDeniedHandler handler = new ThrowingMethodAuthorizationDeniedHandler();

    DeferringObservationReactiveAuthorizationManager(ObjectProvider<ObservationRegistry> provider, ReactiveAuthorizationManager<T> delegate) {
        this.delegate = SingletonSupplier.of(() -> {
            ObservationRegistry registry = (ObservationRegistry)provider.getIfAvailable(() -> ObservationRegistry.NOOP);
            if (registry.isNoop()) {
                return delegate;
            }
            return new ObservationReactiveAuthorizationManager(registry, delegate);
        });
        if (delegate instanceof MethodAuthorizationDeniedHandler) {
            MethodAuthorizationDeniedHandler h;
            this.handler = h = (MethodAuthorizationDeniedHandler)delegate;
        }
    }

    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, T object) {
        return this.delegate.get().check(authentication, object);
    }

    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        return this.handler.handleDeniedInvocation(methodInvocation, authorizationResult);
    }

    public Object handleDeniedInvocationResult(MethodInvocationResult methodInvocationResult, AuthorizationResult authorizationResult) {
        return this.handler.handleDeniedInvocationResult(methodInvocationResult, authorizationResult);
    }
}

