/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.Pointcut;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.util.function.SingletonSupplier;

final class DeferringMethodInterceptor<M extends AuthorizationAdvisor>
implements AuthorizationAdvisor {
    private final Pointcut pointcut;
    private final Supplier<M> delegate;

    DeferringMethodInterceptor(Pointcut pointcut, Supplier<M> delegate) {
        this.pointcut = pointcut;
        this.delegate = SingletonSupplier.of(delegate);
    }

    @Nullable
    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        return ((AuthorizationAdvisor)this.delegate.get()).invoke(invocation);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this;
    }

    public int getOrder() {
        return ((AuthorizationAdvisor)this.delegate.get()).getOrder();
    }

    public boolean isPerInstance() {
        return true;
    }
}

