/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.oidc.session.InMemoryOidcSessionRegistry;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.StringUtils;

final class OAuth2ClientConfigurerUtils {
    private OAuth2ClientConfigurerUtils() {
    }

    static <B extends HttpSecurityBuilder<B>> ClientRegistrationRepository getClientRegistrationRepository(B builder) {
        ClientRegistrationRepository clientRegistrationRepository = builder.getSharedObject(ClientRegistrationRepository.class);
        if (clientRegistrationRepository == null) {
            clientRegistrationRepository = OAuth2ClientConfigurerUtils.getClientRegistrationRepositoryBean(builder);
            builder.setSharedObject(ClientRegistrationRepository.class, (ClientRegistrationRepository)clientRegistrationRepository);
        }
        return clientRegistrationRepository;
    }

    private static <B extends HttpSecurityBuilder<B>> ClientRegistrationRepository getClientRegistrationRepositoryBean(B builder) {
        return (ClientRegistrationRepository)builder.getSharedObject(ApplicationContext.class).getBean(ClientRegistrationRepository.class);
    }

    static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizedClientRepository getAuthorizedClientRepository(B builder) {
        OAuth2AuthorizedClientRepository authorizedClientRepository = builder.getSharedObject(OAuth2AuthorizedClientRepository.class);
        if (authorizedClientRepository == null) {
            authorizedClientRepository = OAuth2ClientConfigurerUtils.getAuthorizedClientRepositoryBean(builder);
            if (authorizedClientRepository == null) {
                authorizedClientRepository = new AuthenticatedPrincipalOAuth2AuthorizedClientRepository(OAuth2ClientConfigurerUtils.getAuthorizedClientService(builder));
            }
            builder.setSharedObject(OAuth2AuthorizedClientRepository.class, (OAuth2AuthorizedClientRepository)authorizedClientRepository);
        }
        return authorizedClientRepository;
    }

    private static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizedClientRepository getAuthorizedClientRepositoryBean(B builder) {
        Map authorizedClientRepositoryMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)builder.getSharedObject(ApplicationContext.class)), OAuth2AuthorizedClientRepository.class);
        if (authorizedClientRepositoryMap.size() > 1) {
            throw new NoUniqueBeanDefinitionException(OAuth2AuthorizedClientRepository.class, authorizedClientRepositoryMap.size(), "Expected single matching bean of type '" + OAuth2AuthorizedClientRepository.class.getName() + "' but found " + authorizedClientRepositoryMap.size() + ": " + StringUtils.collectionToCommaDelimitedString(authorizedClientRepositoryMap.keySet()));
        }
        return !authorizedClientRepositoryMap.isEmpty() ? (OAuth2AuthorizedClientRepository)authorizedClientRepositoryMap.values().iterator().next() : null;
    }

    private static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizedClientService getAuthorizedClientService(B builder) {
        OAuth2AuthorizedClientService authorizedClientService = OAuth2ClientConfigurerUtils.getAuthorizedClientServiceBean(builder);
        if (authorizedClientService == null) {
            authorizedClientService = new InMemoryOAuth2AuthorizedClientService(OAuth2ClientConfigurerUtils.getClientRegistrationRepository(builder));
        }
        return authorizedClientService;
    }

    private static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizedClientService getAuthorizedClientServiceBean(B builder) {
        Map authorizedClientServiceMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)builder.getSharedObject(ApplicationContext.class)), OAuth2AuthorizedClientService.class);
        if (authorizedClientServiceMap.size() > 1) {
            throw new NoUniqueBeanDefinitionException(OAuth2AuthorizedClientService.class, authorizedClientServiceMap.size(), "Expected single matching bean of type '" + OAuth2AuthorizedClientService.class.getName() + "' but found " + authorizedClientServiceMap.size() + ": " + StringUtils.collectionToCommaDelimitedString(authorizedClientServiceMap.keySet()));
        }
        return !authorizedClientServiceMap.isEmpty() ? (OAuth2AuthorizedClientService)authorizedClientServiceMap.values().iterator().next() : null;
    }

    static <B extends HttpSecurityBuilder<B>> OidcSessionRegistry getOidcSessionRegistry(B builder) {
        OidcSessionRegistry sessionRegistry = builder.getSharedObject(OidcSessionRegistry.class);
        if (sessionRegistry == null) {
            sessionRegistry = new InMemoryOidcSessionRegistry();
            builder.setSharedObject(OidcSessionRegistry.class, (OidcSessionRegistry)sessionRegistry);
        }
        return sessionRegistry;
    }
}

