/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationCodeGrantFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

final class OAuth2ClientBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ELT_AUTHORIZATION_CODE_GRANT = "authorization-code-grant";
    private static final String ATT_CLIENT_REGISTRATION_REPOSITORY_REF = "client-registration-repository-ref";
    private static final String ATT_AUTHORIZED_CLIENT_REPOSITORY_REF = "authorized-client-repository-ref";
    private static final String ATT_AUTHORIZED_CLIENT_SERVICE_REF = "authorized-client-service-ref";
    private static final String ATT_AUTHORIZATION_REQUEST_REPOSITORY_REF = "authorization-request-repository-ref";
    private static final String ATT_AUTHORIZATION_REQUEST_RESOLVER_REF = "authorization-request-resolver-ref";
    private static final String ATT_ACCESS_TOKEN_RESPONSE_CLIENT_REF = "access-token-response-client-ref";
    private final BeanReference requestCache;
    private final BeanReference authenticationManager;
    private BeanDefinition authorizationRequestRedirectFilter;
    private BeanDefinition authorizationCodeGrantFilter;
    private BeanDefinition authorizationCodeAuthenticationProvider;

    OAuth2ClientBeanDefinitionParser(BeanReference requestCache, BeanReference authenticationManager) {
        this.requestCache = requestCache;
        this.authenticationManager = authenticationManager;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String authorizationRequestResolverRef;
        Element authorizationCodeGrantElt = DomUtils.getChildElementByTagName((Element)element, (String)ELT_AUTHORIZATION_CODE_GRANT);
        BeanMetadataElement clientRegistrationRepository = this.getClientRegistrationRepository(element);
        BeanMetadataElement authorizedClientRepository = this.getAuthorizedClientRepository(element, clientRegistrationRepository);
        BeanMetadataElement authorizationRequestRepository = this.getAuthorizationRequestRepository(authorizationCodeGrantElt);
        BeanDefinitionBuilder authorizationRequestRedirectFilterBuilder = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizationRequestRedirectFilter.class);
        String string = authorizationRequestResolverRef = authorizationCodeGrantElt != null ? authorizationCodeGrantElt.getAttribute(ATT_AUTHORIZATION_REQUEST_RESOLVER_REF) : null;
        if (!StringUtils.isEmpty((Object)authorizationRequestResolverRef)) {
            authorizationRequestRedirectFilterBuilder.addConstructorArgReference(authorizationRequestResolverRef);
        } else {
            authorizationRequestRedirectFilterBuilder.addConstructorArgValue((Object)clientRegistrationRepository);
        }
        this.authorizationRequestRedirectFilter = authorizationRequestRedirectFilterBuilder.addPropertyValue("authorizationRequestRepository", (Object)authorizationRequestRepository).addPropertyValue("requestCache", (Object)this.requestCache).getBeanDefinition();
        this.authorizationCodeGrantFilter = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizationCodeGrantFilter.class).addConstructorArgValue((Object)clientRegistrationRepository).addConstructorArgValue((Object)authorizedClientRepository).addConstructorArgValue((Object)this.authenticationManager).addPropertyValue("authorizationRequestRepository", (Object)authorizationRequestRepository).getBeanDefinition();
        BeanMetadataElement accessTokenResponseClient = this.getAccessTokenResponseClient(authorizationCodeGrantElt);
        this.authorizationCodeAuthenticationProvider = BeanDefinitionBuilder.rootBeanDefinition(OAuth2AuthorizationCodeAuthenticationProvider.class).addConstructorArgValue((Object)accessTokenResponseClient).getBeanDefinition();
        return null;
    }

    private BeanMetadataElement getClientRegistrationRepository(Element element) {
        String clientRegistrationRepositoryRef = element.getAttribute(ATT_CLIENT_REGISTRATION_REPOSITORY_REF);
        RuntimeBeanReference clientRegistrationRepository = !StringUtils.isEmpty((Object)clientRegistrationRepositoryRef) ? new RuntimeBeanReference(clientRegistrationRepositoryRef) : new RuntimeBeanReference(ClientRegistrationRepository.class);
        return clientRegistrationRepository;
    }

    private BeanMetadataElement getAuthorizedClientRepository(Element element, BeanMetadataElement clientRegistrationRepository) {
        RuntimeBeanReference authorizedClientRepository;
        String authorizedClientRepositoryRef = element.getAttribute(ATT_AUTHORIZED_CLIENT_REPOSITORY_REF);
        if (!StringUtils.isEmpty((Object)authorizedClientRepositoryRef)) {
            authorizedClientRepository = new RuntimeBeanReference(authorizedClientRepositoryRef);
        } else {
            String authorizedClientServiceRef = element.getAttribute(ATT_AUTHORIZED_CLIENT_SERVICE_REF);
            Object authorizedClientService = !StringUtils.isEmpty((Object)authorizedClientServiceRef) ? new RuntimeBeanReference(authorizedClientServiceRef) : BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService").addConstructorArgValue((Object)clientRegistrationRepository).getBeanDefinition();
            authorizedClientRepository = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.oauth2.client.web.AuthenticatedPrincipalOAuth2AuthorizedClientRepository").addConstructorArgValue(authorizedClientService).getBeanDefinition();
        }
        return authorizedClientRepository;
    }

    private BeanMetadataElement getAuthorizationRequestRepository(Element element) {
        String authorizationRequestRepositoryRef = element != null ? element.getAttribute(ATT_AUTHORIZATION_REQUEST_REPOSITORY_REF) : null;
        Object authorizationRequestRepository = !StringUtils.isEmpty((Object)authorizationRequestRepositoryRef) ? new RuntimeBeanReference(authorizationRequestRepositoryRef) : BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizationRequestRepository").getBeanDefinition();
        return authorizationRequestRepository;
    }

    private BeanMetadataElement getAccessTokenResponseClient(Element element) {
        String accessTokenResponseClientRef = element != null ? element.getAttribute(ATT_ACCESS_TOKEN_RESPONSE_CLIENT_REF) : null;
        Object accessTokenResponseClient = !StringUtils.isEmpty((Object)accessTokenResponseClientRef) ? new RuntimeBeanReference(accessTokenResponseClientRef) : BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient").getBeanDefinition();
        return accessTokenResponseClient;
    }

    BeanDefinition getAuthorizationRequestRedirectFilter() {
        return this.authorizationRequestRedirectFilter;
    }

    BeanDefinition getAuthorizationCodeGrantFilter() {
        return this.authorizationCodeGrantFilter;
    }

    BeanDefinition getAuthorizationCodeAuthenticationProvider() {
        return this.authorizationCodeAuthenticationProvider;
    }
}

