/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.NimbusJwtDecoderJwkSetUriFactoryBean;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class JwtBeanDefinitionParser
implements BeanDefinitionParser {
    static final String DECODER_REF = "decoder-ref";
    static final String JWK_SET_URI = "jwk-set-uri";
    static final String JWT_AUTHENTICATION_CONVERTER_REF = "jwt-authentication-converter-ref";
    static final String JWT_AUTHENTICATION_CONVERTER = "jwtAuthenticationConverter";

    public BeanDefinition parse(Element element, ParserContext pc) {
        this.validateConfiguration(element, pc);
        BeanDefinitionBuilder jwtProviderBuilder = BeanDefinitionBuilder.rootBeanDefinition(JwtAuthenticationProvider.class);
        jwtProviderBuilder.addConstructorArgValue(this.getDecoder(element));
        jwtProviderBuilder.addPropertyValue(JWT_AUTHENTICATION_CONVERTER, this.getJwtAuthenticationConverter(element));
        return jwtProviderBuilder.getBeanDefinition();
    }

    void validateConfiguration(Element element, ParserContext pc) {
        boolean usesJwkSetUri;
        boolean usesDecoder = element.hasAttribute(DECODER_REF);
        if (usesDecoder == (usesJwkSetUri = element.hasAttribute(JWK_SET_URI))) {
            pc.getReaderContext().error("Please specify either decoder-ref or jwk-set-uri.", (Object)element);
        }
    }

    Object getDecoder(Element element) {
        String decoderRef = element.getAttribute(DECODER_REF);
        if (!StringUtils.isEmpty((Object)decoderRef)) {
            return new RuntimeBeanReference(decoderRef);
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(NimbusJwtDecoderJwkSetUriFactoryBean.class);
        builder.addConstructorArgValue((Object)element.getAttribute(JWK_SET_URI));
        return builder.getBeanDefinition();
    }

    Object getJwtAuthenticationConverter(Element element) {
        String jwtDecoderRef = element.getAttribute(JWT_AUTHENTICATION_CONVERTER_REF);
        if (!StringUtils.isEmpty((Object)jwtDecoderRef)) {
            return new RuntimeBeanReference(jwtDecoderRef);
        }
        return new JwtAuthenticationConverter();
    }

    JwtBeanDefinitionParser() {
    }
}

