/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.CumulativePermission;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.model.Permission;
import org.springframework.util.Assert;

public class DefaultPermissionFactory
implements PermissionFactory {
    private final Map<Integer, Permission> registeredPermissionsByInteger = new HashMap<Integer, Permission>();
    private final Map<String, Permission> registeredPermissionsByName = new HashMap<String, Permission>();

    public DefaultPermissionFactory() {
        this.registerPublicPermissions(BasePermission.class);
    }

    public DefaultPermissionFactory(Class<? extends Permission> permissionClass) {
        this.registerPublicPermissions(permissionClass);
    }

    public DefaultPermissionFactory(Map<String, ? extends Permission> namedPermissions) {
        for (String name : namedPermissions.keySet()) {
            this.registerPermission(namedPermissions.get(name), name);
        }
    }

    protected void registerPublicPermissions(Class<? extends Permission> clazz) {
        Field[] fields;
        Assert.notNull(clazz, (String)"Class required");
        for (Field field : fields = clazz.getFields()) {
            try {
                Object fieldValue = field.get(null);
                if (!Permission.class.isAssignableFrom(fieldValue.getClass())) continue;
                Permission perm = (Permission)fieldValue;
                String permissionName = field.getName();
                this.registerPermission(perm, permissionName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void registerPermission(Permission perm, String permissionName) {
        Assert.notNull((Object)perm, (String)"Permission required");
        Assert.hasText((String)permissionName, (String)"Permission name required");
        Integer mask = perm.getMask();
        Assert.isTrue((!this.registeredPermissionsByInteger.containsKey(mask) ? 1 : 0) != 0, () -> "An existing Permission already provides mask " + mask);
        Assert.isTrue((!this.registeredPermissionsByName.containsKey(permissionName) ? 1 : 0) != 0, () -> "An existing Permission already provides name '" + permissionName + "'");
        this.registeredPermissionsByInteger.put(mask, perm);
        this.registeredPermissionsByName.put(permissionName, perm);
    }

    @Override
    public Permission buildFromMask(int mask) {
        if (this.registeredPermissionsByInteger.containsKey(mask)) {
            return this.registeredPermissionsByInteger.get(mask);
        }
        CumulativePermission permission = new CumulativePermission();
        for (int i = 0; i < 32; ++i) {
            int permissionToCheck = 1 << i;
            if ((mask & permissionToCheck) != permissionToCheck) continue;
            Permission p = this.registeredPermissionsByInteger.get(permissionToCheck);
            Assert.state((p != null ? 1 : 0) != 0, () -> "Mask '" + permissionToCheck + "' does not have a corresponding static Permission");
            permission.set(p);
        }
        return permission;
    }

    @Override
    public Permission buildFromName(String name) {
        Permission p = this.registeredPermissionsByName.get(name);
        Assert.notNull((Object)p, (String)("Unknown permission '" + name + "'"));
        return p;
    }

    @Override
    public List<Permission> buildFromNames(List<String> names) {
        if (names == null || names.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>(names.size());
        for (String name : names) {
            permissions.add(this.buildFromName(name));
        }
        return permissions;
    }
}

