/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.security.acls.domain.IdentityUnavailableException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ObjectIdentityImpl
implements ObjectIdentity {
    private final String type;
    private Serializable identifier;

    public ObjectIdentityImpl(String type, Serializable identifier) {
        Assert.hasText((String)type, (String)"Type required");
        Assert.notNull((Object)identifier, (String)"identifier required");
        this.identifier = identifier;
        this.type = type;
    }

    public ObjectIdentityImpl(Class<?> javaType, Serializable identifier) {
        Assert.notNull(javaType, (String)"Java Type required");
        Assert.notNull((Object)identifier, (String)"identifier required");
        this.type = javaType.getName();
        this.identifier = identifier;
    }

    public ObjectIdentityImpl(Object object) throws IdentityUnavailableException {
        Assert.notNull((Object)object, (String)"object cannot be null");
        Class typeClass = ClassUtils.getUserClass(object.getClass());
        this.type = typeClass.getName();
        Object result = this.invokeGetIdMethod(object, typeClass);
        Assert.notNull((Object)result, (String)"getId() is required to return a non-null value");
        Assert.isInstanceOf(Serializable.class, (Object)result, (String)"Getter must provide a return value of type Serializable");
        this.identifier = (Serializable)result;
    }

    private Object invokeGetIdMethod(Object object, Class<?> typeClass) {
        try {
            Method method = typeClass.getMethod("getId", new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception ex) {
            throw new IdentityUnavailableException("Could not extract identity from object " + object, ex);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ObjectIdentityImpl)) {
            return false;
        }
        ObjectIdentityImpl other = (ObjectIdentityImpl)obj;
        if (this.identifier instanceof Number && other.identifier instanceof Number ? ((Number)this.identifier).longValue() != ((Number)other.identifier).longValue() : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return this.type.equals(other.type);
    }

    @Override
    public Serializable getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.identifier.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[");
        sb.append("Type: ").append(this.type);
        sb.append("; Identifier: ").append(this.identifier).append("]");
        return sb.toString();
    }
}

