/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.test;

import java.io.File;
import java.util.Properties;
import org.junit.After;
import org.junit.Before;
import org.springframework.security.kerberos.test.MiniKdc;

public class KerberosSecurityTestcase {
    private MiniKdc kdc;
    private File workDir;
    private Properties conf;

    @Before
    public void startMiniKdc() throws Exception {
        this.createTestDir();
        this.createMiniKdcConf();
        this.kdc = new MiniKdc(this.conf, this.workDir);
        this.kdc.start();
    }

    public void createTestDir() {
        this.workDir = new File(System.getProperty("test.dir", "target"));
    }

    public void createMiniKdcConf() {
        this.conf = MiniKdc.createConf();
    }

    @After
    public void stopMiniKdc() {
        if (this.kdc != null) {
            this.kdc.stop();
        }
    }

    public MiniKdc getKdc() {
        return this.kdc;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public Properties getConf() {
        return this.conf;
    }
}

