/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.RecoverAnnotationRecoveryHandler;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.ExponentialRandomBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.backoff.Sleeper;
import org.springframework.retry.backoff.UniformRandomBackOffPolicy;
import org.springframework.retry.interceptor.MethodArgumentsKeyGenerator;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.retry.interceptor.NewMethodArgumentsIdentifier;
import org.springframework.retry.interceptor.RetryInterceptorBuilder;
import org.springframework.retry.policy.MapRetryContextCache;
import org.springframework.retry.policy.RetryContextCache;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AnnotationAwareRetryOperationsInterceptor
implements IntroductionInterceptor,
BeanFactoryAware {
    private final Map<Method, MethodInterceptor> delegates = new HashMap<Method, MethodInterceptor>();
    private RetryContextCache retryContextCache = new MapRetryContextCache();
    private MethodArgumentsKeyGenerator methodArgumentsKeyGenerator;
    private NewMethodArgumentsIdentifier newMethodArgumentsIdentifier;
    private Sleeper sleeper;
    private BeanFactory beanFactory;

    public void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setKeyGenerator(MethodArgumentsKeyGenerator methodArgumentsKeyGenerator) {
        this.methodArgumentsKeyGenerator = methodArgumentsKeyGenerator;
    }

    public void setNewItemIdentifier(NewMethodArgumentsIdentifier newMethodArgumentsIdentifier) {
        this.newMethodArgumentsIdentifier = newMethodArgumentsIdentifier;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public boolean implementsInterface(Class<?> intf) {
        return org.springframework.retry.interceptor.Retryable.class.isAssignableFrom(intf);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        MethodInterceptor delegate = this.getDelegate(invocation.getThis(), invocation.getMethod());
        if (delegate != null) {
            return delegate.invoke(invocation);
        }
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodInterceptor getDelegate(Object target, Method method) {
        if (!this.delegates.containsKey(method)) {
            Map<Method, MethodInterceptor> map = this.delegates;
            synchronized (map) {
                if (!this.delegates.containsKey(method)) {
                    Retryable retryable = (Retryable)AnnotationUtils.findAnnotation((Method)method, Retryable.class);
                    if (retryable == null) {
                        retryable = (Retryable)AnnotationUtils.findAnnotation(method.getDeclaringClass(), Retryable.class);
                    }
                    if (retryable == null) {
                        return this.delegates.put(method, null);
                    }
                    MethodInterceptor delegate = StringUtils.hasText((String)retryable.interceptor()) ? (MethodInterceptor)this.beanFactory.getBean(retryable.interceptor(), MethodInterceptor.class) : (retryable.stateful() ? this.getStatefulInterceptor(target, method, retryable) : this.getStatelessInterceptor(target, method, retryable));
                    this.delegates.put(method, delegate);
                }
            }
        }
        return this.delegates.get(method);
    }

    private MethodInterceptor getStatelessInterceptor(Object target, Method method, Retryable retryable) {
        return RetryInterceptorBuilder.stateless().retryPolicy(this.getRetryPolicy(retryable)).backOffPolicy(this.getBackoffPolicy(retryable.backoff())).recoverer(this.getRecoverer(target, method)).build();
    }

    private MethodInterceptor getStatefulInterceptor(Object target, Method method, Retryable retryable) {
        RetryTemplate template = new RetryTemplate();
        template.setRetryContextCache(this.retryContextCache);
        template.setRetryPolicy(this.getRetryPolicy(retryable));
        template.setBackOffPolicy(this.getBackoffPolicy(retryable.backoff()));
        return ((RetryInterceptorBuilder.StatefulRetryInterceptorBuilder)RetryInterceptorBuilder.stateful().retryOperations(template).recoverer((MethodInvocationRecoverer)this.getRecoverer(target, method))).keyGenerator(this.methodArgumentsKeyGenerator).newMethodArgumentsIdentifier(this.newMethodArgumentsIdentifier).build();
    }

    private MethodInvocationRecoverer<?> getRecoverer(Object target, Method method) {
        if (target instanceof MethodInvocationRecoverer) {
            return (MethodInvocationRecoverer)target;
        }
        final AtomicBoolean foundRecoverable = new AtomicBoolean(false);
        ReflectionUtils.doWithMethods(target.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (AnnotationUtils.findAnnotation((Method)method, Recover.class) != null) {
                    foundRecoverable.set(true);
                }
            }
        });
        if (!foundRecoverable.get()) {
            return null;
        }
        return new RecoverAnnotationRecoveryHandler(target, method);
    }

    private RetryPolicy getRetryPolicy(Retryable retryable) {
        Class<? extends Throwable>[] includes = retryable.value();
        if (includes.length == 0) {
            includes = retryable.include();
        }
        Class<? extends Throwable>[] excludes = retryable.exclude();
        if (includes.length == 0 && excludes.length == 0) {
            SimpleRetryPolicy simple = new SimpleRetryPolicy();
            simple.setMaxAttempts(retryable.maxAttempts());
            return simple;
        }
        HashMap<Class<? extends Throwable>, Boolean> policyMap = new HashMap<Class<? extends Throwable>, Boolean>();
        for (Class<? extends Throwable> type : includes) {
            policyMap.put(type, true);
        }
        for (Class<? extends Throwable> type : excludes) {
            policyMap.put(type, false);
        }
        return new SimpleRetryPolicy(retryable.maxAttempts(), policyMap, true);
    }

    private BackOffPolicy getBackoffPolicy(Backoff backoff) {
        long min = backoff.delay() == 0L ? backoff.value() : backoff.delay();
        long max = backoff.maxDelay();
        if (backoff.multiplier() > 0.0) {
            ExponentialBackOffPolicy policy = new ExponentialBackOffPolicy();
            if (backoff.random()) {
                policy = new ExponentialRandomBackOffPolicy();
            }
            policy.setInitialInterval(min);
            policy.setMultiplier(backoff.multiplier());
            policy.setMaxInterval(max > min ? max : 30000L);
            if (this.sleeper != null) {
                policy.setSleeper(this.sleeper);
            }
            return policy;
        }
        if (max > min) {
            UniformRandomBackOffPolicy policy = new UniformRandomBackOffPolicy();
            policy.setMinBackOffPeriod(min);
            policy.setMaxBackOffPeriod(max);
            if (this.sleeper != null) {
                policy.setSleeper(this.sleeper);
            }
            return policy;
        }
        FixedBackOffPolicy policy = new FixedBackOffPolicy();
        policy.setBackOffPeriod(min);
        if (this.sleeper != null) {
            policy.setSleeper(this.sleeper);
        }
        return policy;
    }
}

