/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.webtestclient;

import java.util.Collection;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.OperationResponseFactory;
import org.springframework.restdocs.operation.ResponseConverter;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.util.StringUtils;

class WebTestClientResponseConverter
implements ResponseConverter<ExchangeResult> {
    WebTestClientResponseConverter() {
    }

    public OperationResponse convert(ExchangeResult result) {
        return new OperationResponseFactory().create(result.getStatus().value(), this.extractHeaders(result), result.getResponseBodyContent());
    }

    private HttpHeaders extractHeaders(ExchangeResult result) {
        HttpHeaders headers = result.getResponseHeaders();
        if (result.getResponseCookies().isEmpty() || headers.containsKey((Object)"Set-Cookie")) {
            return headers;
        }
        result.getResponseCookies().values().stream().flatMap(Collection::stream).forEach(cookie -> headers.add("Set-Cookie", this.generateSetCookieHeader((ResponseCookie)cookie)));
        return headers;
    }

    private String generateSetCookieHeader(ResponseCookie cookie) {
        StringBuilder header = new StringBuilder();
        header.append(cookie.getName());
        header.append('=');
        this.appendIfAvailable(header, cookie.getValue());
        long maxAge = cookie.getMaxAge().getSeconds();
        if (maxAge > -1L) {
            header.append("; Max-Age=");
            header.append(maxAge);
        }
        this.appendIfAvailable(header, "; Domain=", cookie.getDomain());
        this.appendIfAvailable(header, "; Path=", cookie.getPath());
        if (cookie.isSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        return header.toString();
    }

    private void appendIfAvailable(StringBuilder header, String value) {
        if (StringUtils.hasText((String)value)) {
            header.append(value);
        }
    }

    private void appendIfAvailable(StringBuilder header, String name, String value) {
        if (StringUtils.hasText((String)value)) {
            header.append(name);
            header.append(value);
        }
    }
}

