/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.restassured;

import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.HashMap;
import java.util.Map;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.generate.RestDocumentationGenerator;
import org.springframework.restdocs.restassured.RestAssuredRestDocumentationConfigurer;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.util.Assert;

public class RestDocumentationFilter
implements Filter {
    static final String CONTEXT_KEY_CONFIGURATION = "org.springframework.restdocs.configuration";
    private final RestDocumentationGenerator<FilterableRequestSpecification, Response> delegate;

    RestDocumentationFilter(RestDocumentationGenerator<FilterableRequestSpecification, Response> delegate) {
        Assert.notNull(delegate, (String)"delegate must be non-null");
        this.delegate = delegate;
    }

    public final Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext context) {
        Response response = context.next(requestSpec, responseSpec);
        Map<String, Object> configuration = this.getConfiguration(requestSpec, context);
        this.delegate.handle((Object)requestSpec, (Object)response, configuration);
        return response;
    }

    protected Map<String, Object> getConfiguration(FilterableRequestSpecification requestSpec, FilterContext context) {
        HashMap<String, Object> configuration = new HashMap<String, Object>(RestDocumentationFilter.retrieveConfiguration(context));
        configuration.put(RestDocumentationContext.class.getName(), context.getValue(RestDocumentationContext.class.getName()));
        configuration.put("org.springframework.restdocs.urlTemplate", requestSpec.getUserDefinedPath());
        return configuration;
    }

    public final RestDocumentationFilter document(Snippet ... snippets) {
        return new RestDocumentationFilter(this.delegate.withSnippets(snippets)){

            @Override
            protected Map<String, Object> getConfiguration(FilterableRequestSpecification requestSpec, FilterContext context) {
                Map<String, Object> configuration = super.getConfiguration(requestSpec, context);
                configuration.remove("org.springframework.restdocs.defaultSnippets");
                configuration.remove("org.springframework.restdocs.defaultOperationRequestPreprocessor");
                configuration.remove("org.springframework.restdocs.defaultOperationResponsePreprocessor");
                return configuration;
            }
        };
    }

    private static Map<String, Object> retrieveConfiguration(FilterContext context) {
        Map configuration = (Map)context.getValue(CONTEXT_KEY_CONFIGURATION);
        Assert.state((configuration != null ? 1 : 0) != 0, () -> "REST Docs configuration not found. Did you forget to add a " + RestAssuredRestDocumentationConfigurer.class.getSimpleName() + " as a filter when building the RequestSpecification?");
        return configuration;
    }
}

