/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.header;

import java.util.Set;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;

public interface PulsarHeaderMatcher {
    public boolean matchHeader(String var1);

    public boolean isNegated();

    public static class PatternMatch
    implements PulsarHeaderMatcher {
        private static final LogAccessor LOGGER = new LogAccessor(PatternMatch.class);
        private final String pattern;
        private final boolean negate;

        public static PatternMatch fromPatternString(String pattern) {
            return new PatternMatch(pattern.startsWith("!") ? pattern.substring(1) : pattern, pattern.startsWith("!"));
        }

        public PatternMatch(String pattern, boolean negate) {
            Assert.notNull((Object)pattern, (String)"Pattern must not be null");
            this.pattern = pattern.toLowerCase();
            this.negate = negate;
        }

        @Override
        public boolean matchHeader(String headerName) {
            if (!PatternMatchUtils.simpleMatch((String)this.pattern, (String)headerName.toLowerCase())) {
                return false;
            }
            LOGGER.debug(() -> "headerName=[%s] WILL %s be mapped, matched pattern=%s".formatted(headerName, this.negate ? "NOT " : "", this.toPatternString()));
            return true;
        }

        @Override
        public boolean isNegated() {
            return this.negate;
        }

        public String toPatternString() {
            return (this.negate ? "!" : "") + this.pattern;
        }
    }

    public static class NeverMatch
    implements PulsarHeaderMatcher {
        private final Set<String> neverMatchHeaders;

        public NeverMatch(String ... headers) {
            Assert.notEmpty((Object[])headers, (String)"headers must contain at least 1 non-null entry");
            Assert.noNullElements((Object[])headers, (String)"headers must not contain null entries");
            this.neverMatchHeaders = Set.of(headers);
        }

        @Override
        public boolean matchHeader(String headerName) {
            return this.neverMatchHeaders.contains(headerName);
        }

        @Override
        public boolean isNegated() {
            return true;
        }
    }
}

