/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reader;

import org.apache.pulsar.client.api.ReaderListener;
import org.springframework.pulsar.core.AbstractPulsarMessageContainer;
import org.springframework.pulsar.core.PulsarReaderFactory;
import org.springframework.pulsar.core.ReaderBuilderCustomizer;
import org.springframework.pulsar.reader.PulsarMessageReaderContainer;
import org.springframework.pulsar.reader.PulsarReaderContainerProperties;
import org.springframework.util.Assert;

public abstract class AbstractPulsarMessageReaderContainer<T>
extends AbstractPulsarMessageContainer
implements PulsarMessageReaderContainer {
    private final PulsarReaderFactory<T> pulsarReaderFactory;
    private final PulsarReaderContainerProperties pulsarReaderContainerProperties;
    protected final Object lifecycleMonitor = new Object();
    protected ReaderBuilderCustomizer<T> readerBuilderCustomizer;

    protected AbstractPulsarMessageReaderContainer(PulsarReaderFactory<? super T> pulsarReaderFactory, PulsarReaderContainerProperties pulsarReaderContainerProperties) {
        this.pulsarReaderFactory = pulsarReaderFactory;
        this.pulsarReaderContainerProperties = pulsarReaderContainerProperties;
    }

    public PulsarReaderFactory<T> getPulsarReaderFactory() {
        return this.pulsarReaderFactory;
    }

    @Override
    public PulsarReaderContainerProperties getContainerProperties() {
        return this.pulsarReaderContainerProperties;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public void setupReaderListener(Object messageListener) {
        this.pulsarReaderContainerProperties.setReaderListener(messageListener);
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Override
    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                Assert.state((boolean)(this.pulsarReaderContainerProperties.getReaderListener() instanceof ReaderListener), () -> "A " + ReaderListener.class.getName() + " implementation must be provided");
                this.doStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.doStop();
            }
        }
    }

    @Override
    public void setReaderCustomizer(ReaderBuilderCustomizer<?> readerBuilderCustomizer) {
        this.readerBuilderCustomizer = readerBuilderCustomizer;
    }

    public ReaderBuilderCustomizer<T> getReaderBuilderCustomizer() {
        return this.readerBuilderCustomizer;
    }
}

