/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import org.apache.pulsar.client.api.Producer;
import org.springframework.core.log.LogAccessor;

final class ProducerUtils {
    private ProducerUtils() {
    }

    static <T> String formatProducer(Producer<T> producer) {
        return "(%s:%s)".formatted(producer.getProducerName(), producer.getTopic());
    }

    static <T> void closeProducerAsync(Producer<T> producer, LogAccessor logger) {
        producer.closeAsync().exceptionally(e -> {
            logger.warn(e, () -> "Failed to close producer %s".formatted(ProducerUtils.formatProducer(producer)));
            return null;
        });
    }
}

