/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.Resolved;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.util.StringUtils;

public class DefaultTopicResolver
implements TopicResolver {
    private final Map<Class<?>, String> customTopicMappings = new LinkedHashMap();

    @Nullable
    public String addCustomTopicMapping(Class<?> messageType, String topic) {
        return this.customTopicMappings.put(messageType, topic);
    }

    @Nullable
    public String removeCustomMapping(Class<?> messageType) {
        return this.customTopicMappings.remove(messageType);
    }

    public Map<Class<?>, String> getCustomTopicMappings() {
        return Collections.unmodifiableMap(this.customTopicMappings);
    }

    @Override
    public Resolved<String> resolveTopic(@Nullable String userSpecifiedTopic, Supplier<String> defaultTopicSupplier) {
        if (StringUtils.hasText((String)userSpecifiedTopic)) {
            return Resolved.of(userSpecifiedTopic);
        }
        String defaultTopic = defaultTopicSupplier.get();
        if (defaultTopic == null) {
            return Resolved.failed("Topic must be specified when no default topic is configured");
        }
        return Resolved.of(defaultTopic);
    }

    @Override
    public <T> Resolved<String> resolveTopic(@Nullable String userSpecifiedTopic, @Nullable T message, Supplier<String> defaultTopicSupplier) {
        return this.doResolveTopic(userSpecifiedTopic, message != null ? message.getClass() : null, defaultTopicSupplier);
    }

    @Override
    public Resolved<String> resolveTopic(@Nullable String userSpecifiedTopic, @Nullable Class<?> messageType, Supplier<String> defaultTopicSupplier) {
        return this.doResolveTopic(userSpecifiedTopic, messageType, defaultTopicSupplier);
    }

    protected Resolved<String> doResolveTopic(@Nullable String userSpecifiedTopic, @Nullable Class<?> messageType, Supplier<String> defaultTopicSupplier) {
        if (StringUtils.hasText((String)userSpecifiedTopic)) {
            return Resolved.of(userSpecifiedTopic);
        }
        if (messageType == null) {
            return Resolved.failed("Topic must be specified when the message is null");
        }
        String topic = this.customTopicMappings.getOrDefault(messageType, defaultTopicSupplier.get());
        return topic == null ? Resolved.failed("Topic must be specified when no default topic is configured") : Resolved.of(topic);
    }
}

