/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.DefaultTopicResolver;
import org.springframework.pulsar.core.ProducerBuilderConfigurationUtil;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarProducerFactory;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.util.CollectionUtils;

public class DefaultPulsarProducerFactory<T>
implements PulsarProducerFactory<T> {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private final Map<String, Object> producerConfig;
    private final PulsarClient pulsarClient;
    private final TopicResolver topicResolver;

    public DefaultPulsarProducerFactory(PulsarClient pulsarClient, Map<String, Object> config) {
        this(pulsarClient, config, new DefaultTopicResolver());
    }

    public DefaultPulsarProducerFactory(PulsarClient pulsarClient, Map<String, Object> config, TopicResolver topicResolver) {
        this.pulsarClient = pulsarClient;
        this.producerConfig = Collections.unmodifiableMap(config);
        this.topicResolver = topicResolver;
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema, @Nullable String topic) throws PulsarClientException {
        return this.doCreateProducer(schema, topic, null, null);
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema, @Nullable String topic, @Nullable ProducerBuilderCustomizer<T> customizer) throws PulsarClientException {
        return this.doCreateProducer(schema, topic, null, customizer != null ? Collections.singletonList(customizer) : null);
    }

    @Override
    public Producer<T> createProducer(Schema<T> schema, @Nullable String topic, @Nullable Collection<String> encryptionKeys, @Nullable List<ProducerBuilderCustomizer<T>> customizers) throws PulsarClientException {
        return this.doCreateProducer(schema, topic, encryptionKeys, customizers);
    }

    protected Producer<T> doCreateProducer(Schema<T> schema, @Nullable String topic, @Nullable Collection<String> encryptionKeys, @Nullable List<ProducerBuilderCustomizer<T>> customizers) throws PulsarClientException {
        Objects.requireNonNull(schema, "Schema must be specified");
        String resolvedTopic = this.resolveTopicName(topic);
        this.logger.trace(() -> "Creating producer for '%s' topic".formatted(resolvedTopic));
        ProducerBuilder producerBuilder = this.pulsarClient.newProducer(schema);
        HashMap<String, Object> config = new HashMap<String, Object>(this.producerConfig);
        if (encryptionKeys != null) {
            config.put("encryptionKeys", encryptionKeys);
        }
        ProducerBuilderConfigurationUtil.loadConf(producerBuilder, config);
        producerBuilder.topic(resolvedTopic);
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(c -> c.customize(producerBuilder));
        }
        producerBuilder.topic(resolvedTopic);
        return producerBuilder.create();
    }

    protected String resolveTopicName(String userSpecifiedTopic) {
        String defaultTopic = Objects.toString(this.getProducerConfig().get("topicName"), null);
        return this.topicResolver.resolveTopic(userSpecifiedTopic, () -> defaultTopic).orElseThrow();
    }

    @Override
    public Map<String, Object> getProducerConfig() {
        return this.producerConfig;
    }
}

