/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.impl.ConsumerBuilderImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;

public final class ConsumerBuilderConfigurationUtil {
    private ConsumerBuilderConfigurationUtil() {
    }

    public static <T> void loadConf(ConsumerBuilder<T> builder, Map<String, Object> properties) {
        ConsumerConfigurationData builderConf = ((ConsumerBuilderImpl)builder).getConf();
        HashMap<String, Object> propertiesCopy = new HashMap<String, Object>(properties);
        propertiesCopy.remove("messageListener");
        propertiesCopy.remove("consumerEventListener");
        propertiesCopy.remove("negativeAckRedeliveryBackoff");
        propertiesCopy.remove("ackTimeoutRedeliveryBackoff");
        propertiesCopy.remove("cryptoKeyReader");
        propertiesCopy.remove("messageCrypto");
        propertiesCopy.remove("batchReceivePolicy");
        propertiesCopy.remove("keySharedPolicy");
        propertiesCopy.remove("payloadProcessor");
        builder.loadConf(propertiesCopy);
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getMessageListener(), arg_0 -> builder.messageListener(arg_0), properties, "messageListener");
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getConsumerEventListener(), arg_0 -> builder.consumerEventListener(arg_0), properties, "consumerEventListener");
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getNegativeAckRedeliveryBackoff(), arg_0 -> builder.negativeAckRedeliveryBackoff(arg_0), properties, "negativeAckRedeliveryBackoff");
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getAckTimeoutRedeliveryBackoff(), arg_0 -> builder.ackTimeoutRedeliveryBackoff(arg_0), properties, "ackTimeoutRedeliveryBackoff");
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getCryptoKeyReader(), arg_0 -> builder.cryptoKeyReader(arg_0), properties, "cryptoKeyReader");
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getMessageCrypto(), arg_0 -> builder.messageCrypto(arg_0), properties, "messageCrypto");
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getBatchReceivePolicy(), arg_0 -> builder.batchReceivePolicy(arg_0), properties, "batchReceivePolicy");
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getKeySharedPolicy(), arg_0 -> builder.keySharedPolicy(arg_0), properties, "keySharedPolicy");
        ConsumerBuilderConfigurationUtil.applyValueToBuilderAfterLoadConf(() -> ((ConsumerConfigurationData)builderConf).getPayloadProcessor(), arg_0 -> builder.messagePayloadProcessor(arg_0), properties, "payloadProcessor");
    }

    private static <T> void applyValueToBuilderAfterLoadConf(Supplier<T> confGetter, Consumer<T> builderSetter, Map<String, Object> properties, String key) {
        Object value = properties.getOrDefault(key, confGetter.get());
        if (value != null) {
            builderSetter.accept(value);
        }
    }
}

