/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.expression.BeanResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.config.AbstractPulsarReaderEndpoint;
import org.springframework.pulsar.core.ReaderBuilderCustomizer;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.listener.Acknowledgement;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.listener.adapter.HandlerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarRecordMessageToSpringMessageReaderAdapter;
import org.springframework.pulsar.reader.DefaultPulsarMessageReaderContainer;
import org.springframework.pulsar.reader.PulsarMessageReaderContainer;
import org.springframework.pulsar.reader.PulsarReaderContainerProperties;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.pulsar.support.converter.PulsarMessageConverter;
import org.springframework.util.Assert;

public class MethodPulsarReaderEndpoint<V>
extends AbstractPulsarReaderEndpoint<V> {
    private Object bean;
    private Method method;
    private SmartMessageConverter messagingConverter;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private ReaderBuilderCustomizer<?> readerBuilderCustomizer;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    protected AbstractPulsarMessageToSpringMessageAdapter<V> createReaderListener(PulsarMessageReaderContainer container, @Nullable MessageConverter messageConverter) {
        AbstractPulsarMessageToSpringMessageAdapter<V> readerListener = this.createMessageListenerInstance(messageConverter);
        HandlerAdapter handlerMethod = this.configureListenerAdapter(readerListener);
        readerListener.setHandlerMethod(handlerMethod);
        MethodParameter[] methodParameters = handlerMethod.getInvokerHandlerMethod().getMethodParameters();
        MethodParameter messageParameter = null;
        Optional<MethodParameter> parameter = Arrays.stream(methodParameters).filter(methodParameter1 -> !methodParameter1.getParameterType().equals(Consumer.class) || !methodParameter1.getParameterType().equals(Acknowledgement.class) || !methodParameter1.hasParameterAnnotation(Header.class)).findFirst();
        long count = Arrays.stream(methodParameters).filter(methodParameter1 -> !methodParameter1.getParameterType().equals(Consumer.class) && !methodParameter1.getParameterType().equals(Acknowledgement.class) && !methodParameter1.hasParameterAnnotation(Header.class)).count();
        Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)"More than 1 expected payload types found");
        if (parameter.isPresent()) {
            messageParameter = parameter.get();
        }
        DefaultPulsarMessageReaderContainer containerInstance = (DefaultPulsarMessageReaderContainer)container;
        PulsarReaderContainerProperties pulsarContainerProperties = containerInstance.getContainerProperties();
        SchemaResolver schemaResolver = pulsarContainerProperties.getSchemaResolver();
        SchemaType schemaType = pulsarContainerProperties.getSchemaType();
        ResolvableType messageType = this.resolvableType(messageParameter);
        schemaResolver.resolveSchema(schemaType, messageType).ifResolved(pulsarContainerProperties::setSchema);
        if (pulsarContainerProperties.getSchema() != null) {
            SchemaType type = pulsarContainerProperties.getSchema().getSchemaInfo().getType();
            pulsarContainerProperties.setSchemaType(type);
        }
        container.setReaderCustomizer(this.readerBuilderCustomizer);
        return readerListener;
    }

    private ResolvableType resolvableType(MethodParameter methodParameter) {
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
        Class rawClass = resolvableType.getRawClass();
        if (rawClass != null && this.isContainerType(rawClass)) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        if (Message.class.isAssignableFrom(resolvableType.getRawClass()) || org.springframework.messaging.Message.class.isAssignableFrom(resolvableType.getRawClass())) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        return resolvableType;
    }

    private boolean isContainerType(Class<?> rawClass) {
        return rawClass.isAssignableFrom(List.class) || rawClass.isAssignableFrom(Message.class) || rawClass.isAssignableFrom(Messages.class) || rawClass.isAssignableFrom(org.springframework.messaging.Message.class);
    }

    protected HandlerAdapter configureListenerAdapter(AbstractPulsarMessageToSpringMessageAdapter<V> messageListener) {
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected AbstractPulsarMessageToSpringMessageAdapter<V> createMessageListenerInstance(@Nullable MessageConverter messageConverter) {
        BeanResolver resolver;
        PulsarRecordMessageToSpringMessageReaderAdapter messageListener = new PulsarRecordMessageToSpringMessageReaderAdapter(this.bean, this.method);
        if (messageConverter instanceof PulsarMessageConverter) {
            messageListener.setMessageConverter((PulsarMessageConverter)messageConverter);
        }
        PulsarRecordMessageToSpringMessageReaderAdapter listener = messageListener;
        if (this.messagingConverter != null) {
            listener.setMessagingConverter(this.messagingConverter);
        }
        if ((resolver = this.getBeanResolver()) != null) {
            listener.setBeanResolver(resolver);
        }
        return listener;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    public void setReaderBuilderCustomizer(ReaderBuilderCustomizer<?> readerBuilderCustomizer) {
        this.readerBuilderCustomizer = readerBuilderCustomizer;
    }
}

