/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.config.PulsarReaderEndpoint;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.reader.PulsarMessageReaderContainer;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.util.Assert;

public abstract class AbstractPulsarReaderEndpoint<K>
implements PulsarReaderEndpoint<PulsarMessageReaderContainer>,
BeanFactoryAware,
InitializingBean {
    private String subscriptionName;
    private SchemaType schemaType;
    private String id;
    private final List<String> topics = new ArrayList<String>();
    private MessageId startMessageId;
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;
    private BeanResolver beanResolver;
    private Boolean autoStartup;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    @Nullable
    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.getTopics().isEmpty()) {
            throw new IllegalStateException("Topics or topicPattern must be provided but not both for " + this);
        }
    }

    @Nullable
    protected BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    @Nullable
    protected BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    @Nullable
    protected BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @Override
    @Nullable
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setTopics(String ... topics) {
        Assert.notNull((Object)topics, (String)"'topics' must not be null");
        this.topics.clear();
        this.topics.addAll(Arrays.asList(topics));
    }

    @Override
    public List<String> getTopics() {
        return Collections.unmodifiableList(this.topics);
    }

    @Override
    @Nullable
    public Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public void setupListenerContainer(PulsarMessageReaderContainer listenerContainer, @Nullable MessageConverter messageConverter) {
        this.setupMessageListener(listenerContainer, messageConverter);
    }

    private void setupMessageListener(PulsarMessageReaderContainer container, @Nullable MessageConverter messageConverter) {
        AbstractPulsarMessageToSpringMessageAdapter<K> adapter = this.createReaderListener(container, messageConverter);
        AbstractPulsarMessageToSpringMessageAdapter<K> messageListener = adapter;
        Assert.state((messageListener != null ? 1 : 0) != 0, () -> "Endpoint [" + this + "] must provide a non null message listener");
        container.setupReaderListener(messageListener);
    }

    protected abstract AbstractPulsarMessageToSpringMessageAdapter<K> createReaderListener(PulsarMessageReaderContainer var1, @Nullable MessageConverter var2);

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    @Override
    public MessageId getStartMessageId() {
        return this.startMessageId;
    }

    public void setStartMessageId(MessageId startMessageId) {
        this.startMessageId = startMessageId;
    }
}

