/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.config.PulsarListenerEndpoint;
import org.springframework.pulsar.listener.AckMode;
import org.springframework.pulsar.listener.PulsarMessageListenerContainer;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractPulsarListenerEndpoint<K>
implements PulsarListenerEndpoint,
BeanFactoryAware,
InitializingBean {
    private String subscriptionName;
    private SubscriptionType subscriptionType;
    private SchemaType schemaType;
    private String id;
    private final Collection<String> topics = new ArrayList<String>();
    private String topicPattern;
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;
    private BeanResolver beanResolver;
    private Boolean autoStartup;
    private Properties consumerProperties;
    private Boolean batchListener;
    private Integer concurrency;
    private AckMode ackMode;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    @Nullable
    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() {
        boolean topicsEmpty = this.getTopics().isEmpty();
        if (!topicsEmpty && !StringUtils.hasText((String)this.getTopicPattern())) {
            throw new IllegalStateException("Topics or topicPattern must be provided but not both for " + this);
        }
    }

    @Nullable
    protected BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    @Nullable
    protected BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    @Nullable
    protected BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @Override
    @Nullable
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setTopics(String ... topics) {
        Assert.notNull((Object)topics, (String)"'topics' must not be null");
        this.topics.clear();
        this.topics.addAll(Arrays.asList(topics));
    }

    @Override
    public Collection<String> getTopics() {
        return Collections.unmodifiableCollection(this.topics);
    }

    public void setTopicPattern(String topicPattern) {
        Assert.notNull((Object)topicPattern, (String)"'topicPattern' must not be null");
        this.topicPattern = topicPattern;
    }

    @Override
    public String getTopicPattern() {
        return this.topicPattern;
    }

    @Override
    @Nullable
    public Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public void setupListenerContainer(PulsarMessageListenerContainer listenerContainer, @Nullable MessageConverter messageConverter) {
        this.setupMessageListener(listenerContainer, messageConverter);
    }

    private void setupMessageListener(PulsarMessageListenerContainer container, @Nullable MessageConverter messageConverter) {
        AbstractPulsarMessageToSpringMessageAdapter<K> adapter;
        AbstractPulsarMessageToSpringMessageAdapter<K> messageListener = adapter = this.createMessageListener(container, messageConverter);
        boolean isBatchListener = this.isBatchListener();
        Assert.state((messageListener != null ? 1 : 0) != 0, () -> "Endpoint [" + this + "] must provide a non null message listener");
        container.setupMessageListener(messageListener);
    }

    protected abstract AbstractPulsarMessageToSpringMessageAdapter<K> createMessageListener(PulsarMessageListenerContainer var1, @Nullable MessageConverter var2);

    public void setConsumerProperties(Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    @Override
    public Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    @Nullable
    public Boolean getBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(boolean batchListener) {
        this.batchListener = batchListener;
    }

    @Override
    public boolean isBatchListener() {
        return this.batchListener == null ? false : this.batchListener;
    }

    @Override
    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    @Override
    @Nullable
    public Integer getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AckMode ackMode) {
        this.ackMode = ackMode;
    }
}

