/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.reactive.client.adapter.AdaptedReactivePulsarClientFactory;
import org.apache.pulsar.reactive.client.adapter.ProducerCacheProvider;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderCache;
import org.apache.pulsar.reactive.client.api.ReactivePulsarClient;
import org.apache.pulsar.reactive.client.producercache.CaffeineProducerCacheProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.pulsar.autoconfigure.PulsarAutoConfiguration;
import org.springframework.pulsar.autoconfigure.PulsarReactiveAnnotationDrivenConfiguration;
import org.springframework.pulsar.autoconfigure.PulsarReactiveProperties;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.reactive.core.DefaultReactivePulsarConsumerFactory;
import org.springframework.pulsar.reactive.core.DefaultReactivePulsarReaderFactory;
import org.springframework.pulsar.reactive.core.DefaultReactivePulsarSenderFactory;
import org.springframework.pulsar.reactive.core.ReactivePulsarConsumerFactory;
import org.springframework.pulsar.reactive.core.ReactivePulsarReaderFactory;
import org.springframework.pulsar.reactive.core.ReactivePulsarSenderFactory;
import org.springframework.pulsar.reactive.core.ReactivePulsarTemplate;

@AutoConfiguration(after={PulsarAutoConfiguration.class})
@ConditionalOnClass(value={ReactivePulsarTemplate.class, ReactivePulsarClient.class})
@EnableConfigurationProperties(value={PulsarReactiveProperties.class})
@Import(value={PulsarReactiveAnnotationDrivenConfiguration.class})
public class PulsarReactiveAutoConfiguration {
    private final PulsarReactiveProperties properties;

    public PulsarReactiveAutoConfiguration(PulsarReactiveProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactivePulsarClient pulsarReactivePulsarClient(PulsarClient pulsarClient) {
        return AdaptedReactivePulsarClientFactory.create((PulsarClient)pulsarClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={CaffeineProducerCacheProvider.class})
    @ConditionalOnProperty(name={"spring.pulsar.reactive.sender.cache.enabled"}, havingValue="true", matchIfMissing=true)
    public ProducerCacheProvider pulsarProducerCacheProvider() {
        PulsarReactiveProperties.Cache cache = this.properties.getSender().getCache();
        Caffeine caffeine = Caffeine.newBuilder().expireAfterAccess(cache.getExpireAfterAccess()).maximumSize(cache.getMaximumSize().longValue()).initialCapacity(cache.getInitialCapacity().intValue());
        return new CaffeineProducerCacheProvider(caffeine);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.pulsar.reactive.sender.cache.enabled"}, havingValue="true", matchIfMissing=true)
    public ReactiveMessageSenderCache pulsarReactiveMessageSenderCache(ObjectProvider<ProducerCacheProvider> producerCacheProvider) {
        return producerCacheProvider.stream().findFirst().map(AdaptedReactivePulsarClientFactory::createCache).orElseGet(AdaptedReactivePulsarClientFactory::createCache);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactivePulsarSenderFactory<?> reactivePulsarSenderFactory(ReactivePulsarClient pulsarReactivePulsarClient, ObjectProvider<ReactiveMessageSenderCache> cache, TopicResolver topicResolver) {
        return new DefaultReactivePulsarSenderFactory(pulsarReactivePulsarClient, this.properties.buildReactiveMessageSenderSpec(), (ReactiveMessageSenderCache)cache.getIfAvailable(), topicResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactivePulsarConsumerFactory<?> reactivePulsarConsumerFactory(ReactivePulsarClient pulsarReactivePulsarClient) {
        return new DefaultReactivePulsarConsumerFactory(pulsarReactivePulsarClient, this.properties.buildReactiveMessageConsumerSpec());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactivePulsarReaderFactory<?> reactivePulsarReaderFactory(ReactivePulsarClient pulsarReactivePulsarClient) {
        return new DefaultReactivePulsarReaderFactory(pulsarReactivePulsarClient, this.properties.buildReactiveMessageReaderSpec());
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactivePulsarTemplate<?> pulsarReactiveTemplate(ReactivePulsarSenderFactory<?> reactivePulsarSenderFactory, SchemaResolver schemaResolver, TopicResolver topicResolver) {
        return new ReactivePulsarTemplate(reactivePulsarSenderFactory, schemaResolver, topicResolver);
    }
}

