/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.autoconfigure.AuthParameterUtils;
import org.springframework.pulsar.autoconfigure.ConsumerConfigProperties;
import org.springframework.pulsar.autoconfigure.ProducerConfigProperties;
import org.springframework.pulsar.listener.AckMode;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="spring.pulsar")
public class PulsarProperties {
    @NestedConfigurationProperty
    private final ConsumerConfigProperties consumer = new ConsumerConfigProperties();
    private final Client client = new Client();
    private final Function function = new Function();
    private final Listener listener = new Listener();
    @NestedConfigurationProperty
    private final ProducerConfigProperties producer = new ProducerConfigProperties();
    private final Template template = new Template();
    private final Admin admin = new Admin();
    private final Reader reader = new Reader();
    private final Defaults defaults = new Defaults();

    public ConsumerConfigProperties getConsumer() {
        return this.consumer;
    }

    public Client getClient() {
        return this.client;
    }

    public Listener getListener() {
        return this.listener;
    }

    public Function getFunction() {
        return this.function;
    }

    public ProducerConfigProperties getProducer() {
        return this.producer;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Admin getAdministration() {
        return this.admin;
    }

    public Reader getReader() {
        return this.reader;
    }

    public Defaults getDefaults() {
        return this.defaults;
    }

    public Map<String, Object> buildConsumerProperties() {
        return new HashMap<String, Object>(this.consumer.buildProperties());
    }

    public Map<String, Object> buildClientProperties() {
        return new HashMap<String, Object>(this.client.buildProperties());
    }

    public Map<String, Object> buildProducerProperties() {
        return new HashMap<String, Object>(this.producer.buildProperties());
    }

    public Map<String, Object> buildAdminProperties() {
        return new HashMap<String, Object>(this.admin.buildProperties());
    }

    public Map<String, Object> buildReaderProperties() {
        return new HashMap<String, Object>(this.reader.buildProperties());
    }

    public static class Client {
        private String serviceUrl = "pulsar://localhost:6650";
        private String listenerName;
        private String authPluginClassName;
        private String authParams;
        private Map<String, String> authentication;
        private Duration operationTimeout = Duration.ofSeconds(30L);
        private Duration lookupTimeout = Duration.ofMillis(-1L);
        private Integer numIoThreads = 1;
        private Integer numListenerThreads = 1;
        private Integer numConnectionsPerBroker = 1;
        private Boolean useTcpNoDelay = true;
        private Boolean useTls = false;
        private Boolean tlsHostnameVerificationEnable = false;
        private String tlsTrustCertsFilePath;
        private Boolean tlsAllowInsecureConnection = false;
        private Boolean useKeyStoreTls = false;
        private String sslProvider;
        private String tlsTrustStoreType;
        private String tlsTrustStorePath;
        private String tlsTrustStorePassword;
        private Set<String> tlsCiphers;
        private Set<String> tlsProtocols;
        private Duration statsInterval = Duration.ofSeconds(60L);
        private Integer maxConcurrentLookupRequest = 5000;
        private Integer maxLookupRequest = 50000;
        private Integer maxLookupRedirects = 20;
        private Integer maxNumberOfRejectedRequestPerConnection = 50;
        private Duration keepAliveInterval = Duration.ofSeconds(30L);
        private Duration connectionTimeout = Duration.ofSeconds(10L);
        private Duration requestTimeout = Duration.ofMinutes(1L);
        private Duration initialBackoffInterval = Duration.ofMillis(100L);
        private Duration maxBackoffInterval = Duration.ofSeconds(30L);
        private Boolean enableBusyWait = false;
        private DataSize memoryLimit = DataSize.ofMegabytes((long)64L);
        private String proxyServiceUrl;
        private ProxyProtocol proxyProtocol;
        private Boolean enableTransaction = false;
        private String dnsLookupBindAddress;
        private Integer dnsLookupBindPort = 0;
        private String socks5ProxyAddress;
        private String socks5ProxyUsername;
        private String socks5ProxyPassword;

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public void setListenerName(String listenerName) {
            this.listenerName = listenerName;
        }

        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        public void setAuthPluginClassName(String authPluginClassName) {
            this.authPluginClassName = authPluginClassName;
        }

        public String getAuthParams() {
            return this.authParams;
        }

        public void setAuthParams(String authParams) {
            this.authParams = authParams;
        }

        public Map<String, String> getAuthentication() {
            return this.authentication;
        }

        public void setAuthentication(Map<String, String> authentication) {
            this.authentication = authentication;
        }

        public Duration getOperationTimeout() {
            return this.operationTimeout;
        }

        public void setOperationTimeout(Duration operationTimeout) {
            this.operationTimeout = operationTimeout;
        }

        public Duration getLookupTimeout() {
            return this.lookupTimeout;
        }

        public void setLookupTimeout(Duration lookupTimeout) {
            this.lookupTimeout = lookupTimeout;
        }

        public Integer getNumIoThreads() {
            return this.numIoThreads;
        }

        public void setNumIoThreads(Integer numIoThreads) {
            this.numIoThreads = numIoThreads;
        }

        public Integer getNumListenerThreads() {
            return this.numListenerThreads;
        }

        public void setNumListenerThreads(Integer numListenerThreads) {
            this.numListenerThreads = numListenerThreads;
        }

        public Integer getNumConnectionsPerBroker() {
            return this.numConnectionsPerBroker;
        }

        public void setNumConnectionsPerBroker(Integer numConnectionsPerBroker) {
            this.numConnectionsPerBroker = numConnectionsPerBroker;
        }

        public Boolean getUseTcpNoDelay() {
            return this.useTcpNoDelay;
        }

        public void setUseTcpNoDelay(Boolean useTcpNoDelay) {
            this.useTcpNoDelay = useTcpNoDelay;
        }

        public Boolean getUseTls() {
            return this.useTls;
        }

        public void setUseTls(Boolean useTls) {
            this.useTls = useTls;
        }

        public Boolean getTlsHostnameVerificationEnable() {
            return this.tlsHostnameVerificationEnable;
        }

        public void setTlsHostnameVerificationEnable(Boolean tlsHostnameVerificationEnable) {
            this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        }

        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }

        public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
            this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        }

        public Boolean getTlsAllowInsecureConnection() {
            return this.tlsAllowInsecureConnection;
        }

        public void setTlsAllowInsecureConnection(Boolean tlsAllowInsecureConnection) {
            this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        }

        public Boolean getUseKeyStoreTls() {
            return this.useKeyStoreTls;
        }

        public void setUseKeyStoreTls(Boolean useKeyStoreTls) {
            this.useKeyStoreTls = useKeyStoreTls;
        }

        public String getSslProvider() {
            return this.sslProvider;
        }

        public void setSslProvider(String sslProvider) {
            this.sslProvider = sslProvider;
        }

        public String getTlsTrustStoreType() {
            return this.tlsTrustStoreType;
        }

        public void setTlsTrustStoreType(String tlsTrustStoreType) {
            this.tlsTrustStoreType = tlsTrustStoreType;
        }

        public String getTlsTrustStorePath() {
            return this.tlsTrustStorePath;
        }

        public void setTlsTrustStorePath(String tlsTrustStorePath) {
            this.tlsTrustStorePath = tlsTrustStorePath;
        }

        public String getTlsTrustStorePassword() {
            return this.tlsTrustStorePassword;
        }

        public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
            this.tlsTrustStorePassword = tlsTrustStorePassword;
        }

        public Set<String> getTlsCiphers() {
            return this.tlsCiphers;
        }

        public void setTlsCiphers(Set<String> tlsCiphers) {
            this.tlsCiphers = tlsCiphers;
        }

        public Set<String> getTlsProtocols() {
            return this.tlsProtocols;
        }

        public void setTlsProtocols(Set<String> tlsProtocols) {
            this.tlsProtocols = tlsProtocols;
        }

        public Duration getStatsInterval() {
            return this.statsInterval;
        }

        public void setStatsInterval(Duration statsInterval) {
            this.statsInterval = statsInterval;
        }

        public Integer getMaxConcurrentLookupRequest() {
            return this.maxConcurrentLookupRequest;
        }

        public void setMaxConcurrentLookupRequest(Integer maxConcurrentLookupRequest) {
            this.maxConcurrentLookupRequest = maxConcurrentLookupRequest;
        }

        public Integer getMaxLookupRequest() {
            return this.maxLookupRequest;
        }

        public void setMaxLookupRequest(Integer maxLookupRequest) {
            this.maxLookupRequest = maxLookupRequest;
        }

        public Integer getMaxLookupRedirects() {
            return this.maxLookupRedirects;
        }

        public void setMaxLookupRedirects(Integer maxLookupRedirects) {
            this.maxLookupRedirects = maxLookupRedirects;
        }

        public Integer getMaxNumberOfRejectedRequestPerConnection() {
            return this.maxNumberOfRejectedRequestPerConnection;
        }

        public void setMaxNumberOfRejectedRequestPerConnection(Integer maxNumberOfRejectedRequestPerConnection) {
            this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
        }

        public Duration getKeepAliveInterval() {
            return this.keepAliveInterval;
        }

        public void setKeepAliveInterval(Duration keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
        }

        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        public Duration getInitialBackoffInterval() {
            return this.initialBackoffInterval;
        }

        public void setInitialBackoffInterval(Duration initialBackoffInterval) {
            this.initialBackoffInterval = initialBackoffInterval;
        }

        public Duration getMaxBackoffInterval() {
            return this.maxBackoffInterval;
        }

        public void setMaxBackoffInterval(Duration maxBackoffInterval) {
            this.maxBackoffInterval = maxBackoffInterval;
        }

        public Boolean getEnableBusyWait() {
            return this.enableBusyWait;
        }

        public void setEnableBusyWait(Boolean enableBusyWait) {
            this.enableBusyWait = enableBusyWait;
        }

        public DataSize getMemoryLimit() {
            return this.memoryLimit;
        }

        public void setMemoryLimit(DataSize memoryLimit) {
            this.memoryLimit = memoryLimit;
        }

        public String getProxyServiceUrl() {
            return this.proxyServiceUrl;
        }

        public void setProxyServiceUrl(String proxyServiceUrl) {
            this.proxyServiceUrl = proxyServiceUrl;
        }

        public ProxyProtocol getProxyProtocol() {
            return this.proxyProtocol;
        }

        public void setProxyProtocol(ProxyProtocol proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
        }

        public Boolean getEnableTransaction() {
            return this.enableTransaction;
        }

        public void setEnableTransaction(Boolean enableTransaction) {
            this.enableTransaction = enableTransaction;
        }

        public String getDnsLookupBindAddress() {
            return this.dnsLookupBindAddress;
        }

        public void setDnsLookupBindAddress(String dnsLookupBindAddress) {
            this.dnsLookupBindAddress = dnsLookupBindAddress;
        }

        public Integer getDnsLookupBindPort() {
            return this.dnsLookupBindPort;
        }

        public void setDnsLookupBindPort(Integer dnsLookupBindPort) {
            this.dnsLookupBindPort = dnsLookupBindPort;
        }

        public String getSocks5ProxyAddress() {
            return this.socks5ProxyAddress;
        }

        public void setSocks5ProxyAddress(String socks5ProxyAddress) {
            this.socks5ProxyAddress = socks5ProxyAddress;
        }

        public String getSocks5ProxyUsername() {
            return this.socks5ProxyUsername;
        }

        public void setSocks5ProxyUsername(String socks5ProxyUsername) {
            this.socks5ProxyUsername = socks5ProxyUsername;
        }

        public String getSocks5ProxyPassword() {
            return this.socks5ProxyPassword;
        }

        public void setSocks5ProxyPassword(String socks5ProxyPassword) {
            this.socks5ProxyPassword = socks5ProxyPassword;
        }

        public Map<String, Object> buildProperties() {
            if (StringUtils.hasText((String)this.getAuthParams()) && !CollectionUtils.isEmpty(this.getAuthentication())) {
                throw new IllegalArgumentException("Cannot set both spring.pulsar.client.authParams and spring.pulsar.client.authentication.*");
            }
            Properties properties = new Properties();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(this::getServiceUrl).to(properties.in("serviceUrl"));
            map.from(this::getListenerName).to(properties.in("listenerName"));
            map.from(this::getAuthPluginClassName).to(properties.in("authPluginClassName"));
            map.from(this::getAuthParams).to(properties.in("authParams"));
            map.from(this::getAuthentication).as(AuthParameterUtils::maybeConvertToEncodedParamString).to(properties.in("authParams"));
            map.from(this::getOperationTimeout).as(Duration::toMillis).to(properties.in("operationTimeoutMs"));
            map.from(this::getLookupTimeout).as(Duration::toMillis).to(properties.in("lookupTimeoutMs"));
            map.from(this::getNumIoThreads).to(properties.in("numIoThreads"));
            map.from(this::getNumListenerThreads).to(properties.in("numListenerThreads"));
            map.from(this::getNumConnectionsPerBroker).to(properties.in("connectionsPerBroker"));
            map.from(this::getUseTcpNoDelay).to(properties.in("useTcpNoDelay"));
            map.from(this::getUseTls).to(properties.in("useTls"));
            map.from(this::getTlsHostnameVerificationEnable).to(properties.in("tlsHostnameVerificationEnable"));
            map.from(this::getTlsTrustCertsFilePath).to(properties.in("tlsTrustCertsFilePath"));
            map.from(this::getTlsAllowInsecureConnection).to(properties.in("tlsAllowInsecureConnection"));
            map.from(this::getUseKeyStoreTls).to(properties.in("useKeyStoreTls"));
            map.from(this::getSslProvider).to(properties.in("sslProvider"));
            map.from(this::getTlsTrustStoreType).to(properties.in("tlsTrustStoreType"));
            map.from(this::getTlsTrustStorePath).to(properties.in("tlsTrustStorePath"));
            map.from(this::getTlsTrustStorePassword).to(properties.in("tlsTrustStorePassword"));
            map.from(this::getTlsCiphers).to(properties.in("tlsCiphers"));
            map.from(this::getTlsProtocols).to(properties.in("tlsProtocols"));
            map.from(this::getStatsInterval).as(Duration::toSeconds).to(properties.in("statsIntervalSeconds"));
            map.from(this::getMaxConcurrentLookupRequest).to(properties.in("concurrentLookupRequest"));
            map.from(this::getMaxLookupRequest).to(properties.in("maxLookupRequest"));
            map.from(this::getMaxLookupRedirects).to(properties.in("maxLookupRedirects"));
            map.from(this::getMaxNumberOfRejectedRequestPerConnection).to(properties.in("maxNumberOfRejectedRequestPerConnection"));
            map.from(this::getKeepAliveInterval).asInt(Duration::toSeconds).to(properties.in("keepAliveIntervalSeconds"));
            map.from(this::getConnectionTimeout).asInt(Duration::toMillis).to(properties.in("connectionTimeoutMs"));
            map.from(this::getRequestTimeout).asInt(Duration::toMillis).to(properties.in("requestTimeoutMs"));
            map.from(this::getInitialBackoffInterval).as(Duration::toNanos).to(properties.in("initialBackoffIntervalNanos"));
            map.from(this::getMaxBackoffInterval).as(Duration::toNanos).to(properties.in("maxBackoffIntervalNanos"));
            map.from(this::getEnableBusyWait).to(properties.in("enableBusyWait"));
            map.from(this::getMemoryLimit).as(DataSize::toBytes).to(properties.in("memoryLimitBytes"));
            map.from(this::getProxyServiceUrl).to(properties.in("proxyServiceUrl"));
            map.from(this::getProxyProtocol).to(properties.in("proxyProtocol"));
            map.from(this::getEnableTransaction).to(properties.in("enableTransaction"));
            map.from(this::getDnsLookupBindAddress).to(properties.in("dnsLookupBindAddress"));
            map.from(this::getDnsLookupBindPort).to(properties.in("dnsLookupBindPort"));
            map.from(this::getSocks5ProxyAddress).to(properties.in("socks5ProxyAddress"));
            map.from(this::getSocks5ProxyUsername).to(properties.in("socks5ProxyUsername"));
            map.from(this::getSocks5ProxyPassword).to(properties.in("socks5ProxyPassword"));
            return properties;
        }
    }

    public static class Function {
        private Boolean failFast = Boolean.TRUE;
        private Boolean propagateFailures = Boolean.TRUE;
        private Boolean propagateStopFailures = Boolean.FALSE;

        public Boolean getFailFast() {
            return this.failFast;
        }

        public void setFailFast(Boolean failFast) {
            this.failFast = failFast;
        }

        public Boolean getPropagateFailures() {
            return this.propagateFailures;
        }

        public void setPropagateFailures(Boolean propagateFailures) {
            this.propagateFailures = propagateFailures;
        }

        public Boolean getPropagateStopFailures() {
            return this.propagateStopFailures;
        }

        public void setPropagateStopFailures(Boolean propagateStopFailures) {
            this.propagateStopFailures = propagateStopFailures;
        }
    }

    public static class Listener {
        private AckMode ackMode;
        private SchemaType schemaType;
        private Integer maxNumMessages = -1;
        private DataSize maxNumBytes = DataSize.ofMegabytes((long)10L);
        private Duration batchTimeout = Duration.ofMillis(100L);
        private Boolean observationsEnabled = true;

        public AckMode getAckMode() {
            return this.ackMode;
        }

        public void setAckMode(AckMode ackMode) {
            this.ackMode = ackMode;
        }

        public SchemaType getSchemaType() {
            return this.schemaType;
        }

        public void setSchemaType(SchemaType schemaType) {
            this.schemaType = schemaType;
        }

        public Integer getMaxNumMessages() {
            return this.maxNumMessages;
        }

        public void setMaxNumMessages(Integer maxNumMessages) {
            this.maxNumMessages = maxNumMessages;
        }

        public DataSize getMaxNumBytes() {
            return this.maxNumBytes;
        }

        public void setMaxNumBytes(DataSize maxNumBytes) {
            this.maxNumBytes = maxNumBytes;
        }

        public Duration getBatchTimeout() {
            return this.batchTimeout;
        }

        public void setBatchTimeout(Duration batchTimeout) {
            this.batchTimeout = batchTimeout;
        }

        public Boolean isObservationsEnabled() {
            return this.observationsEnabled;
        }

        public void setObservationsEnabled(Boolean observationsEnabled) {
            this.observationsEnabled = observationsEnabled;
        }
    }

    public static class Template {
        private Boolean observationsEnabled = true;

        public Boolean isObservationsEnabled() {
            return this.observationsEnabled;
        }

        public void setObservationsEnabled(Boolean observationsEnabled) {
            this.observationsEnabled = observationsEnabled;
        }
    }

    public static class Admin {
        private String serviceUrl = "http://localhost:8080";
        private String authPluginClassName;
        private String authParams;
        private Map<String, String> authentication;
        private String tlsTrustCertsFilePath;
        private Boolean tlsAllowInsecureConnection = false;
        private Boolean tlsHostnameVerificationEnable = false;
        private Boolean useKeyStoreTls = false;
        private String sslProvider;
        private String tlsTrustStoreType;
        private String tlsTrustStorePath;
        private String tlsTrustStorePassword;
        private Set<String> tlsCiphers;
        private Set<String> tlsProtocols;
        private Duration connectionTimeout = Duration.ofMinutes(1L);
        private Duration readTimeout = Duration.ofMinutes(1L);
        private Duration requestTimeout = Duration.ofMinutes(5L);
        private Duration autoCertRefreshTime = Duration.ofMinutes(5L);

        public String getServiceUrl() {
            return this.serviceUrl;
        }

        public void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        public String getAuthPluginClassName() {
            return this.authPluginClassName;
        }

        public void setAuthPluginClassName(String authPluginClassName) {
            this.authPluginClassName = authPluginClassName;
        }

        public String getAuthParams() {
            return this.authParams;
        }

        public void setAuthParams(String authParams) {
            this.authParams = authParams;
        }

        public Map<String, String> getAuthentication() {
            return this.authentication;
        }

        public void setAuthentication(Map<String, String> authentication) {
            this.authentication = authentication;
        }

        public String getTlsTrustCertsFilePath() {
            return this.tlsTrustCertsFilePath;
        }

        public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
            this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        }

        public Boolean isTlsAllowInsecureConnection() {
            return this.tlsAllowInsecureConnection;
        }

        public void setTlsAllowInsecureConnection(Boolean tlsAllowInsecureConnection) {
            this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        }

        public Boolean isTlsHostnameVerificationEnable() {
            return this.tlsHostnameVerificationEnable;
        }

        public void setTlsHostnameVerificationEnable(Boolean tlsHostnameVerificationEnable) {
            this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        }

        public Boolean isUseKeyStoreTls() {
            return this.useKeyStoreTls;
        }

        public void setUseKeyStoreTls(Boolean useKeyStoreTls) {
            this.useKeyStoreTls = useKeyStoreTls;
        }

        public String getSslProvider() {
            return this.sslProvider;
        }

        public void setSslProvider(String sslProvider) {
            this.sslProvider = sslProvider;
        }

        public String getTlsTrustStoreType() {
            return this.tlsTrustStoreType;
        }

        public void setTlsTrustStoreType(String tlsTrustStoreType) {
            this.tlsTrustStoreType = tlsTrustStoreType;
        }

        public String getTlsTrustStorePath() {
            return this.tlsTrustStorePath;
        }

        public void setTlsTrustStorePath(String tlsTrustStorePath) {
            this.tlsTrustStorePath = tlsTrustStorePath;
        }

        public String getTlsTrustStorePassword() {
            return this.tlsTrustStorePassword;
        }

        public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
            this.tlsTrustStorePassword = tlsTrustStorePassword;
        }

        public Set<String> getTlsCiphers() {
            return this.tlsCiphers;
        }

        public void setTlsCiphers(Set<String> tlsCiphers) {
            this.tlsCiphers = tlsCiphers;
        }

        public Set<String> getTlsProtocols() {
            return this.tlsProtocols;
        }

        public void setTlsProtocols(Set<String> tlsProtocols) {
            this.tlsProtocols = tlsProtocols;
        }

        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        public Duration getAutoCertRefreshTime() {
            return this.autoCertRefreshTime;
        }

        public void setAutoCertRefreshTime(Duration autoCertRefreshTime) {
            this.autoCertRefreshTime = autoCertRefreshTime;
        }

        public Map<String, Object> buildProperties() {
            if (StringUtils.hasText((String)this.getAuthParams()) && !CollectionUtils.isEmpty(this.getAuthentication())) {
                throw new IllegalArgumentException("Cannot set both spring.pulsar.administration.authParams and spring.pulsar.administration.authentication.*");
            }
            Properties properties = new Properties();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(this::getServiceUrl).to(properties.in("serviceUrl"));
            map.from(this::getAuthPluginClassName).to(properties.in("authPluginClassName"));
            map.from(this::getAuthParams).to(properties.in("authParams"));
            map.from(this::getAuthentication).as(AuthParameterUtils::maybeConvertToEncodedParamString).to(properties.in("authParams"));
            map.from(this::getTlsTrustCertsFilePath).to(properties.in("tlsTrustCertsFilePath"));
            map.from(this::isTlsAllowInsecureConnection).to(properties.in("tlsAllowInsecureConnection"));
            map.from(this::isTlsHostnameVerificationEnable).to(properties.in("tlsHostnameVerificationEnable"));
            map.from(this::isUseKeyStoreTls).to(properties.in("useKeyStoreTls"));
            map.from(this::getSslProvider).to(properties.in("sslProvider"));
            map.from(this::getTlsTrustStoreType).to(properties.in("tlsTrustStoreType"));
            map.from(this::getTlsTrustStorePath).to(properties.in("tlsTrustStorePath"));
            map.from(this::getTlsTrustStorePassword).to(properties.in("tlsTrustStorePassword"));
            map.from(this::getTlsCiphers).to(properties.in("tlsCiphers"));
            map.from(this::getTlsProtocols).to(properties.in("tlsProtocols"));
            map.from(this::getConnectionTimeout).asInt(Duration::toMillis).to(properties.in("connectionTimeoutMs"));
            map.from(this::getReadTimeout).asInt(Duration::toMillis).to(properties.in("readTimeoutMs"));
            map.from(this::getRequestTimeout).asInt(Duration::toMillis).to(properties.in("requestTimeoutMs"));
            map.from(this::getAutoCertRefreshTime).asInt(Duration::toSeconds).to(properties.in("autoCertRefreshSeconds"));
            return properties;
        }
    }

    public static class Reader {
        private List<String> topicNames;
        private Integer receiverQueueSize;
        private String readerName;
        private String subscriptionName;
        private String subscriptionRolePrefix;
        private Boolean readCompacted;
        private Boolean resetIncludeHead;

        public List<String> getTopicNames() {
            return this.topicNames;
        }

        public void setTopicNames(List<String> topicNames) {
            this.topicNames = topicNames;
        }

        public Integer getReceiverQueueSize() {
            return this.receiverQueueSize;
        }

        public void setReceiverQueueSize(Integer receiverQueueSize) {
            this.receiverQueueSize = receiverQueueSize;
        }

        public String getReaderName() {
            return this.readerName;
        }

        public void setReaderName(String readerName) {
            this.readerName = readerName;
        }

        public String getSubscriptionName() {
            return this.subscriptionName;
        }

        public void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public String getSubscriptionRolePrefix() {
            return this.subscriptionRolePrefix;
        }

        public void setSubscriptionRolePrefix(String subscriptionRolePrefix) {
            this.subscriptionRolePrefix = subscriptionRolePrefix;
        }

        public Boolean getReadCompacted() {
            return this.readCompacted;
        }

        public void setReadCompacted(Boolean readCompacted) {
            this.readCompacted = readCompacted;
        }

        public Boolean getResetIncludeHead() {
            return this.resetIncludeHead;
        }

        public void setResetIncludeHead(Boolean resetIncludeHead) {
            this.resetIncludeHead = resetIncludeHead;
        }

        public Map<String, Object> buildProperties() {
            Properties properties = new Properties();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(this::getTopicNames).to(properties.in("topicNames"));
            map.from(this::getReceiverQueueSize).to(properties.in("receiverQueueSize"));
            map.from(this::getReaderName).to(properties.in("readerName"));
            map.from(this::getSubscriptionName).to(properties.in("subscriptionName"));
            map.from(this::getSubscriptionRolePrefix).to(properties.in("subscriptionRolePrefix"));
            map.from(this::getReadCompacted).to(properties.in("readCompacted"));
            map.from(this::getResetIncludeHead).to(properties.in("resetIncludeHead"));
            return properties;
        }
    }

    public static class Defaults {
        private List<TypeMapping> typeMappings = new ArrayList<TypeMapping>();

        public List<TypeMapping> getTypeMappings() {
            return this.typeMappings;
        }

        public void setTypeMappings(List<TypeMapping> typeMappings) {
            this.typeMappings = typeMappings;
        }
    }

    static class Properties
    extends HashMap<String, Object> {
        Properties() {
        }

        <V> Consumer<V> in(String key) {
            return value -> this.put(key, value);
        }
    }

    public record SchemaInfo(SchemaType schemaType, @Nullable Class<?> messageKeyType) {
        public SchemaInfo {
            Objects.requireNonNull(schemaType, "schemaType must not be null");
            if (schemaType == SchemaType.NONE) {
                throw new IllegalArgumentException("schemaType NONE not supported");
            }
            if (schemaType != SchemaType.KEY_VALUE && messageKeyType != null) {
                throw new IllegalArgumentException("messageKeyType can only be set when schemaType is KEY_VALUE");
            }
        }
    }

    public record TypeMapping(Class<?> messageType, @Nullable String topicName, @Nullable SchemaInfo schemaInfo) {
        public TypeMapping {
            Objects.requireNonNull(messageType, "messageType must not be null");
            if (topicName == null && schemaInfo == null) {
                throw new IllegalArgumentException("At least one of topicName or schemaInfo must not be null");
            }
        }
    }

    public static class Cache {
        private Duration expireAfterAccess = Duration.ofMinutes(1L);
        private Long maximumSize = 1000L;
        private Integer initialCapacity = 50;

        public Duration getExpireAfterAccess() {
            return this.expireAfterAccess;
        }

        public void setExpireAfterAccess(Duration expireAfterAccess) {
            this.expireAfterAccess = expireAfterAccess;
        }

        public Long getMaximumSize() {
            return this.maximumSize;
        }

        public void setMaximumSize(Long maximumSize) {
            this.maximumSize = maximumSize;
        }

        public Integer getInitialCapacity() {
            return this.initialCapacity;
        }

        public void setInitialCapacity(Integer initialCapacity) {
            this.initialCapacity = initialCapacity;
        }
    }
}

