/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.pulsar.annotation.EnablePulsar;
import org.springframework.pulsar.autoconfigure.PulsarProperties;
import org.springframework.pulsar.config.ConcurrentPulsarListenerContainerFactory;
import org.springframework.pulsar.config.DefaultPulsarReaderContainerFactory;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.core.PulsarReaderFactory;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.observation.PulsarListenerObservationConvention;
import org.springframework.pulsar.reader.PulsarReaderContainerProperties;
import org.springframework.util.unit.DataSize;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EnablePulsar.class})
public class PulsarAnnotationDrivenConfiguration {
    private final PulsarProperties pulsarProperties;

    public PulsarAnnotationDrivenConfiguration(PulsarProperties pulsarProperties) {
        this.pulsarProperties = pulsarProperties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"pulsarListenerContainerFactory"})
    ConcurrentPulsarListenerContainerFactory<?> pulsarListenerContainerFactory(ObjectProvider<PulsarConsumerFactory<Object>> consumerFactoryProvider, ObjectProvider<ObservationRegistry> observationRegistryProvider, ObjectProvider<PulsarListenerObservationConvention> observationConventionProvider, SchemaResolver schemaResolver, TopicResolver topicResolver) {
        PulsarContainerProperties containerProperties = new PulsarContainerProperties(new String[0]);
        containerProperties.setSchemaResolver(schemaResolver);
        containerProperties.setTopicResolver(topicResolver);
        containerProperties.setSubscriptionType(this.pulsarProperties.getConsumer().getSubscriptionType());
        containerProperties.setObservationConvention((PulsarListenerObservationConvention)observationConventionProvider.getIfUnique());
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        PulsarProperties.Listener listenerProperties = this.pulsarProperties.getListener();
        map.from(listenerProperties::getSchemaType).to(arg_0 -> ((PulsarContainerProperties)containerProperties).setSchemaType(arg_0));
        map.from(listenerProperties::getAckMode).to(arg_0 -> ((PulsarContainerProperties)containerProperties).setAckMode(arg_0));
        map.from(listenerProperties::getBatchTimeout).asInt(Duration::toMillis).to(arg_0 -> ((PulsarContainerProperties)containerProperties).setBatchTimeoutMillis(arg_0));
        map.from(listenerProperties::getMaxNumBytes).asInt(DataSize::toBytes).to(arg_0 -> ((PulsarContainerProperties)containerProperties).setMaxNumBytes(arg_0));
        map.from(listenerProperties::getMaxNumMessages).to(arg_0 -> ((PulsarContainerProperties)containerProperties).setMaxNumMessages(arg_0));
        return new ConcurrentPulsarListenerContainerFactory((PulsarConsumerFactory)consumerFactoryProvider.getIfAvailable(), containerProperties, this.pulsarProperties.getListener().isObservationsEnabled() != false ? (ObservationRegistry)observationRegistryProvider.getIfUnique() : null);
    }

    @Bean
    @ConditionalOnMissingBean(name={"pulsarReaderContainerFactory"})
    DefaultPulsarReaderContainerFactory<?> pulsarReaderContainerFactory(ObjectProvider<PulsarReaderFactory<Object>> readerFactoryProvider, SchemaResolver schemaResolver) {
        PulsarReaderContainerProperties containerProperties = new PulsarReaderContainerProperties();
        containerProperties.setSchemaResolver(schemaResolver);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        PulsarProperties.Reader readerProperties = this.pulsarProperties.getReader();
        map.from(readerProperties::getTopicNames).to(arg_0 -> ((PulsarReaderContainerProperties)containerProperties).setTopics(arg_0));
        return new DefaultPulsarReaderContainerFactory((PulsarReaderFactory)readerFactoryProvider.getIfAvailable(), containerProperties);
    }

    @Configuration(proxyBeanMethods=false)
    @EnablePulsar
    @ConditionalOnMissingBean(name={"org.springframework.pulsar.config.internalPulsarListenerAnnotationProcessor", "org.springframework.pulsar.config.internalPulsarReaderAnnotationProcessor"})
    static class EnablePulsarConfiguration {
        EnablePulsarConfiguration() {
        }
    }
}

