/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.listener;

import java.time.Duration;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.pulsar.core.DefaultSchemaResolver;
import org.springframework.pulsar.core.DefaultTopicResolver;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.reactive.listener.ReactivePulsarMessageHandler;

public class ReactivePulsarContainerProperties<T> {
    private Collection<String> topics;
    private Pattern topicsPattern;
    private String subscriptionName;
    private SubscriptionType subscriptionType;
    private Schema<T> schema;
    private SchemaType schemaType;
    private SchemaResolver schemaResolver = new DefaultSchemaResolver();
    private TopicResolver topicResolver = new DefaultTopicResolver();
    private ReactivePulsarMessageHandler messageHandler;
    private Duration handlingTimeout = Duration.ofMinutes(2L);
    private int concurrency = 0;
    private boolean useKeyOrderedProcessing = false;

    public ReactivePulsarMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(ReactivePulsarMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public Schema<T> getSchema() {
        return this.schema;
    }

    public void setSchema(Schema<T> schema) {
        this.schema = schema;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public SchemaResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public TopicResolver getTopicResolver() {
        return this.topicResolver;
    }

    public void setTopicResolver(TopicResolver topicResolver) {
        this.topicResolver = topicResolver;
    }

    public Collection<String> getTopics() {
        return this.topics;
    }

    public void setTopics(Collection<String> topics) {
        this.topics = topics;
    }

    public Pattern getTopicsPattern() {
        return this.topicsPattern;
    }

    public void setTopicsPattern(Pattern topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public void setTopicsPattern(String topicsPattern) {
        this.topicsPattern = Pattern.compile(topicsPattern);
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public Duration getHandlingTimeout() {
        return this.handlingTimeout;
    }

    public void setHandlingTimeout(Duration handlingTimeout) {
        this.handlingTimeout = handlingTimeout;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public boolean isUseKeyOrderedProcessing() {
        return this.useKeyOrderedProcessing;
    }

    public void setUseKeyOrderedProcessing(boolean useKeyOrderedProcessing) {
        this.useKeyOrderedProcessing = useKeyOrderedProcessing;
    }
}

