/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.core;

import java.util.Collections;
import java.util.List;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReader;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderBuilder;
import org.apache.pulsar.reactive.client.api.ReactivePulsarClient;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.reactive.core.ReactiveMessageReaderBuilderCustomizer;
import org.springframework.pulsar.reactive.core.ReactivePulsarReaderFactory;
import org.springframework.util.CollectionUtils;

public class DefaultReactivePulsarReaderFactory<T>
implements ReactivePulsarReaderFactory<T> {
    private final ReactivePulsarClient reactivePulsarClient;
    @Nullable
    private final List<ReactiveMessageReaderBuilderCustomizer<T>> defaultConfigCustomizers;

    public DefaultReactivePulsarReaderFactory(ReactivePulsarClient reactivePulsarClient, List<ReactiveMessageReaderBuilderCustomizer<T>> defaultConfigCustomizers) {
        this.reactivePulsarClient = reactivePulsarClient;
        this.defaultConfigCustomizers = defaultConfigCustomizers;
    }

    @Override
    public ReactiveMessageReader<T> createReader(Schema<T> schema) {
        return this.createReader(schema, Collections.emptyList());
    }

    @Override
    public ReactiveMessageReader<T> createReader(Schema<T> schema, List<ReactiveMessageReaderBuilderCustomizer<T>> customizers) {
        ReactiveMessageReaderBuilder readerBuilder = this.reactivePulsarClient.messageReader(schema);
        if (!CollectionUtils.isEmpty(this.defaultConfigCustomizers)) {
            this.defaultConfigCustomizers.forEach(customizer -> customizer.customize(readerBuilder));
        }
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(c -> c.customize(readerBuilder));
        }
        return readerBuilder.build();
    }
}

