/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.mock.MockBundleContext;

public class MockBundle
implements Bundle {
    private String location;
    private Dictionary headers;
    private static int GENERAL_BUNDLE_ID = 0;
    private long bundleId = GENERAL_BUNDLE_ID++;
    private BundleContext bundleContext;
    private ClassLoader loader = this.getClass().getClassLoader();
    private Dictionary defaultHeaders = new Hashtable(0);
    private final String SYMBOLIC_NAME = "Mock-Bundle_" + System.currentTimeMillis();
    private final String symName;

    public MockBundle() {
        this(null, null, null);
    }

    public MockBundle(Dictionary headers) {
        this(null, headers, null);
    }

    public MockBundle(BundleContext context) {
        this(null, null, context);
    }

    public MockBundle(String symName) {
        this(symName, null, null);
    }

    public MockBundle(String symName, Dictionary headers, BundleContext context) {
        this.symName = symName != null && symName.length() > 0 ? symName : this.SYMBOLIC_NAME;
        this.defaultHeaders.put("Bundle-SymbolicName", this.symName);
        this.location = "<default location>";
        this.headers = headers == null ? this.defaultHeaders : headers;
        this.bundleContext = context == null ? new MockBundleContext(this) : context;
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        EmptyEnumeration enm = null;
        try {
            enm = this.loader.getResources(path + "/" + filePattern);
        }
        catch (IOException ex) {
            System.err.println("returning an empty enumeration as cannot load resource; exception " + ex);
        }
        return enm == null ? new EmptyEnumeration() : enm;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(long bundleId) {
        this.bundleId = bundleId;
    }

    public URL getEntry(String name) {
        return this.loader.getResource(name);
    }

    public Enumeration getEntryPaths(String path) {
        return new EmptyEnumeration();
    }

    public Dictionary getHeaders() {
        return this.headers;
    }

    public Dictionary getHeaders(String locale) {
        return this.getHeaders();
    }

    public long getLastModified() {
        return 0L;
    }

    public String getLocation() {
        return this.location;
    }

    public ServiceReference[] getRegisteredServices() {
        return new ServiceReference[0];
    }

    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return this.loader.getResources(name);
    }

    public ServiceReference[] getServicesInUse() {
        return new ServiceReference[0];
    }

    public int getState() {
        return 32;
    }

    public String getSymbolicName() {
        String name = (String)this.headers.get("Bundle-SymbolicName");
        return name == null ? this.SYMBOLIC_NAME : name;
    }

    public boolean hasPermission(Object permission) {
        return true;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
    }

    public void uninstall() throws BundleException {
    }

    public void update() throws BundleException {
    }

    public void update(InputStream in) throws BundleException {
    }

    public BundleContext getContext() {
        return this.bundleContext;
    }

    public BundleContext getBundleContext() {
        return this.getContext();
    }

    public String toString() {
        return this.symName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setClassLoader(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("A non-null class loader expected");
        }
        this.loader = loader;
    }

    private static class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

