/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.modulith.test.AssertablePublishedEvents;
import org.springframework.modulith.test.PublishedEventsParameterResolver;
import org.springframework.modulith.test.Scenario;
import org.springframework.modulith.test.ScenarioCustomizer;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.support.TransactionTemplate;

class ScenarioParameterResolver
implements ParameterResolver,
AfterEachCallback {
    private static final String MISSING_TRANSACTION_TEMPLATE = "To use a Scenario in an integration test you need to define a bean of type TransactionTemplate! Please check your ApplicationContext setup.";
    private final PublishedEventsParameterResolver delegate = new PublishedEventsParameterResolver();

    public void afterEach(ExtensionContext context) throws Exception {
        this.delegate.afterEach(context);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return Scenario.class.isAssignableFrom(type);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        ApplicationContext context = SpringExtension.getApplicationContext((ExtensionContext)extensionContext);
        TransactionTemplate operations = this.resolveTransactionTemplate(context);
        AssertablePublishedEvents events = (AssertablePublishedEvents)this.delegate.resolveParameter(parameterContext, extensionContext);
        return new Scenario(operations, (ApplicationEventPublisher)context, events).setDefaultCustomizer(ScenarioCustomizer.forwardExecutorService(context));
    }

    private TransactionTemplate resolveTransactionTemplate(ApplicationContext context) {
        try {
            return (TransactionTemplate)context.getBean(TransactionTemplate.class);
        }
        catch (NoSuchBeanDefinitionException o_O) {
            throw new ParameterResolutionException(MISSING_TRANSACTION_TEMPLATE, (Throwable)o_O);
        }
    }
}

