/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.matcher.impl;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.modulith.aptk.tools.TypeUtils;
import org.springframework.modulith.aptk.tools.matcher.CriteriaMatcher;

public class ByParameterTypeMirrorMatcher
implements CriteriaMatcher<ExecutableElement, TypeMirror[]> {
    @Override
    public boolean checkForMatchingCharacteristic(ExecutableElement element, TypeMirror[] toCheckFor) {
        if (element == null || toCheckFor == null) {
            return false;
        }
        if (element.getParameters().size() != toCheckFor.length) {
            return false;
        }
        for (int i = 0; i < element.getParameters().size(); ++i) {
            TypeMirror parameterTypeMirror = toCheckFor[i];
            if (parameterTypeMirror == null) {
                return false;
            }
            if (TypeUtils.TypeComparison.isErasedTypeEqual(element.getParameters().get(i).asType(), parameterTypeMirror)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getStringRepresentationOfPassedCharacteristic(TypeMirror[] toGetStringRepresentationFor) {
        if (toGetStringRepresentationFor != null) {
            StringBuilder stringBuilder = new StringBuilder("[");
            boolean isFirst = true;
            for (TypeMirror element : toGetStringRepresentationFor) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(element.toString());
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return null;
    }
}

