/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.generics;

import org.springframework.modulith.aptk.tools.generics.GenericType;
import org.springframework.modulith.aptk.tools.generics.GenericTypeKind;
import org.springframework.modulith.aptk.tools.generics.GenericTypeParameter;

public final class GenericTypeWildcard
implements GenericTypeParameter {
    private final GenericType superBound;
    private final GenericType extendsBound;

    private GenericTypeWildcard(GenericType superBound, GenericType extendsBound) {
        this.superBound = superBound;
        this.extendsBound = extendsBound;
    }

    public GenericType getSuperBound() {
        return this.superBound;
    }

    public GenericType getExtendsBound() {
        return this.extendsBound;
    }

    public boolean isPureWildcard() {
        return this.superBound == null && this.extendsBound == null;
    }

    public boolean hasExtendsBound() {
        return this.extendsBound != null;
    }

    public boolean hasSuperBound() {
        return this.superBound != null;
    }

    @Override
    public GenericTypeKind getType() {
        return GenericTypeKind.WILDCARD;
    }

    public static GenericTypeWildcard createPureWildcard() {
        return GenericTypeWildcard.createWildcard(null, null);
    }

    public static GenericTypeWildcard createExtendsWildcard(GenericType extendsBound) {
        return GenericTypeWildcard.createWildcard(null, extendsBound);
    }

    public static GenericTypeWildcard createSuperWildcard(GenericType superBound) {
        return GenericTypeWildcard.createWildcard(superBound, null);
    }

    private static GenericTypeWildcard createWildcard(GenericType superBound, GenericType extendsBound) {
        return new GenericTypeWildcard(superBound, extendsBound);
    }
}

