/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test.unboundid;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldif.LDIFReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.naming.Binding;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.ldap.UncategorizedLdapException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapAttributes;
import org.springframework.ldap.ldif.parser.LdifParser;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.ldap.test.unboundid.EmbeddedLdapServer;

public final class LdapTestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapTestUtils.class);
    private static EmbeddedLdapServer embeddedServer;

    private LdapTestUtils() {
    }

    public static void startEmbeddedServer(int port, String defaultPartitionSuffix, String defaultPartitionName) {
        if (embeddedServer != null) {
            throw new IllegalStateException("An embedded server is already started");
        }
        try {
            embeddedServer = EmbeddedLdapServer.newEmbeddedServer(defaultPartitionName, defaultPartitionSuffix, port);
        }
        catch (Exception e) {
            throw new UncategorizedLdapException("Failed to start embedded server", (Throwable)e);
        }
    }

    public static void shutdownEmbeddedServer() throws Exception {
        if (embeddedServer != null) {
            embeddedServer.shutdown();
            embeddedServer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSubContexts(ContextSource contextSource, Name name) throws NamingException {
        DirContext ctx = null;
        try {
            ctx = contextSource.getReadWriteContext();
            LdapTestUtils.clearSubContexts(ctx, name);
        }
        finally {
            try {
                ctx.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSubContexts(DirContext ctx, Name name) throws NamingException {
        NamingEnumeration<Binding> enumeration = null;
        try {
            enumeration = ctx.listBindings(name);
            while (enumeration.hasMore()) {
                Binding element = enumeration.next();
                LdapName childName = LdapUtils.newLdapName((String)element.getName());
                childName = LdapUtils.prepend((Name)childName, (Name)name);
                try {
                    ctx.unbind(childName);
                }
                catch (ContextNotEmptyException e) {
                    LdapTestUtils.clearSubContexts(ctx, (Name)childName);
                    ctx.unbind(childName);
                }
            }
        }
        catch (NamingException e) {
            LOGGER.debug("Error cleaning sub-contexts", (Throwable)e);
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLdif(ContextSource contextSource, Resource ldifFile) throws IOException {
        DirContext context = contextSource.getReadWriteContext();
        try {
            LdapTestUtils.loadLdif(context, ldifFile);
        }
        finally {
            try {
                context.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void cleanAndSetup(ContextSource contextSource, Name rootNode, Resource ldifFile) throws NamingException, IOException {
        LdapTestUtils.clearSubContexts(contextSource, rootNode);
        LdapTestUtils.loadLdif(contextSource, ldifFile);
    }

    private static void loadLdif(DirContext context, Resource ldifFile) throws IOException {
        LdapTestUtils.loadLdif(context, LdapUtils.emptyLdapName(), ldifFile);
    }

    private static void loadLdif(DirContext context, Name rootNode, Resource ldifFile) {
        try {
            LdapName baseDn = (LdapName)context.getEnvironment().get("org.springframework.ldap.base.path");
            LdifParser parser = new LdifParser(ldifFile);
            parser.open();
            while (parser.hasMoreRecords()) {
                LdapAttributes record = parser.getRecord();
                LdapName dn = record.getName();
                if (baseDn != null) {
                    dn = LdapUtils.removeFirst((Name)dn, (Name)baseDn);
                }
                if (!rootNode.isEmpty()) {
                    dn = LdapUtils.prepend((Name)dn, (Name)rootNode);
                }
                context.bind(dn, null, (Attributes)record);
            }
        }
        catch (Exception e) {
            throw new UncategorizedLdapException("Failed to populate LDIF", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLdif(InMemoryDirectoryServer directoryServer, Resource ldifFile) throws IOException {
        File tempFile = File.createTempFile("spring_ldap_test", ".ldif");
        try {
            InputStream inputStream = ldifFile.getInputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(tempFile));
            directoryServer.importFromLDIF(true, new LDIFReader(tempFile));
            directoryServer.restartServer();
        }
        catch (LDAPException e) {
            e.printStackTrace();
        }
        finally {
            try {
                tempFile.delete();
            }
            catch (Exception exception) {}
        }
    }
}

