/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.mapping;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.ClassUtils;

@Deprecated(forRemoval=true, since="4.0")
public abstract class AbstractJavaTypeMapper
implements BeanClassLoaderAware {
    public static final String DEFAULT_CLASSID_FIELD_NAME = "__TypeId__";
    public static final String DEFAULT_CONTENT_CLASSID_FIELD_NAME = "__ContentTypeId__";
    public static final String DEFAULT_KEY_CLASSID_FIELD_NAME = "__KeyTypeId__";
    public static final String KEY_DEFAULT_CLASSID_FIELD_NAME = "__Key_TypeId__";
    public static final String KEY_DEFAULT_CONTENT_CLASSID_FIELD_NAME = "__Key_ContentTypeId__";
    public static final String KEY_DEFAULT_KEY_CLASSID_FIELD_NAME = "__Key_KeyTypeId__";
    private final Map<String, Class<?>> idClassMapping = new ConcurrentHashMap();
    private final Map<Class<?>, byte[]> classIdMapping = new ConcurrentHashMap();
    private String classIdFieldName = "__TypeId__";
    private String contentClassIdFieldName = "__ContentTypeId__";
    private String keyClassIdFieldName = "__KeyTypeId__";
    private @Nullable ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public String getClassIdFieldName() {
        return this.classIdFieldName;
    }

    public void setClassIdFieldName(String classIdFieldName) {
        this.classIdFieldName = classIdFieldName;
    }

    public String getContentClassIdFieldName() {
        return this.contentClassIdFieldName;
    }

    public void setContentClassIdFieldName(String contentClassIdFieldName) {
        this.contentClassIdFieldName = contentClassIdFieldName;
    }

    public String getKeyClassIdFieldName() {
        return this.keyClassIdFieldName;
    }

    public void setKeyClassIdFieldName(String keyClassIdFieldName) {
        this.keyClassIdFieldName = keyClassIdFieldName;
    }

    public void setIdClassMapping(Map<String, Class<?>> idClassMapping) {
        this.idClassMapping.putAll(idClassMapping);
        this.createReverseMap();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void addHeader(Headers headers, String headerName, Class<?> clazz) {
        if (this.classIdMapping.containsKey(clazz)) {
            headers.add((Header)new RecordHeader(headerName, this.classIdMapping.get(clazz)));
        } else {
            headers.add((Header)new RecordHeader(headerName, clazz.getName().getBytes(StandardCharsets.UTF_8)));
        }
    }

    protected String retrieveHeader(Headers headers, String headerName) {
        String classId = this.retrieveHeaderAsString(headers, headerName);
        if (classId == null) {
            throw new MessageConversionException("failed to convert Message content. Could not resolve " + headerName + " in header");
        }
        return classId;
    }

    protected @Nullable String retrieveHeaderAsString(Headers headers, String headerName) {
        Header header = headers.lastHeader(headerName);
        if (header != null) {
            String classId = null;
            if (header.value() != null) {
                classId = new String(header.value(), StandardCharsets.UTF_8);
            }
            return classId;
        }
        return null;
    }

    private void createReverseMap() {
        this.classIdMapping.clear();
        for (Map.Entry<String, Class<?>> entry : this.idClassMapping.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            this.classIdMapping.put(clazz, id.getBytes(StandardCharsets.UTF_8));
        }
    }

    public Map<String, Class<?>> getIdClassMapping() {
        return Collections.unmodifiableMap(this.idClassMapping);
    }

    public void setUseForKey(boolean isKey) {
        if (isKey) {
            this.setClassIdFieldName(KEY_DEFAULT_CLASSID_FIELD_NAME);
            this.setContentClassIdFieldName(KEY_DEFAULT_CONTENT_CLASSID_FIELD_NAME);
            this.setKeyClassIdFieldName(KEY_DEFAULT_KEY_CLASSID_FIELD_NAME);
        }
    }
}

