/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryResolver;
import org.springframework.kafka.support.AllowDenyCollectionManager;
import org.springframework.kafka.support.EndpointHandlerMethod;

public class RetryTopicConfiguration {
    private final List<DestinationTopic.Properties> destinationTopicProperties;
    private final AllowDenyCollectionManager<String> topicAllowListManager;
    private final @Nullable EndpointHandlerMethod dltHandlerMethod;
    private final TopicCreation kafkaTopicAutoCreationConfig;
    private final ListenerContainerFactoryResolver.Configuration factoryResolverConfig;
    private final @Nullable Integer concurrency;

    RetryTopicConfiguration(List<DestinationTopic.Properties> destinationTopicProperties, @Nullable EndpointHandlerMethod dltHandlerMethod, TopicCreation kafkaTopicAutoCreationConfig, AllowDenyCollectionManager<String> topicAllowListManager, ListenerContainerFactoryResolver.Configuration factoryResolverConfig, @Nullable Integer concurrency) {
        this.destinationTopicProperties = destinationTopicProperties;
        this.dltHandlerMethod = dltHandlerMethod;
        this.kafkaTopicAutoCreationConfig = kafkaTopicAutoCreationConfig;
        this.topicAllowListManager = topicAllowListManager;
        this.factoryResolverConfig = factoryResolverConfig;
        this.concurrency = concurrency;
    }

    public boolean hasConfigurationForTopics(String[] topics) {
        return this.topicAllowListManager.areAllowed((String[])topics);
    }

    public TopicCreation forKafkaTopicAutoCreation() {
        return this.kafkaTopicAutoCreationConfig;
    }

    public ListenerContainerFactoryResolver.Configuration forContainerFactoryResolver() {
        return this.factoryResolverConfig;
    }

    public @Nullable EndpointHandlerMethod getDltHandlerMethod() {
        return this.dltHandlerMethod;
    }

    public List<DestinationTopic.Properties> getDestinationTopicProperties() {
        return this.destinationTopicProperties;
    }

    public @Nullable Integer getConcurrency() {
        return this.concurrency;
    }

    static class TopicCreation {
        private final boolean shouldCreateTopics;
        private final int numPartitions;
        private final short replicationFactor;

        TopicCreation(@Nullable Boolean shouldCreate, @Nullable Integer numPartitions, @Nullable Short replicationFactor) {
            this.shouldCreateTopics = shouldCreate == null || shouldCreate != false;
            this.numPartitions = numPartitions == null ? 1 : numPartitions;
            this.replicationFactor = (short)(replicationFactor == null ? -1 : (int)replicationFactor.shortValue());
        }

        TopicCreation() {
            this.shouldCreateTopics = true;
            this.numPartitions = 1;
            this.replicationFactor = (short)-1;
        }

        TopicCreation(boolean shouldCreateTopics) {
            this.shouldCreateTopics = shouldCreateTopics;
            this.numPartitions = 1;
            this.replicationFactor = (short)-1;
        }

        public int getNumPartitions() {
            return this.numPartitions;
        }

        public short getReplicationFactor() {
            return this.replicationFactor;
        }

        public boolean shouldCreateTopics() {
            return this.shouldCreateTopics;
        }
    }
}

