/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.FixedBackOff;

public class BackOffValuesGenerator {
    private static final BackOff DEFAULT_BACKOFF = new FixedBackOff(1000L);
    private final int numberOfValuesToCreate;
    private final BackOff backOff;

    public BackOffValuesGenerator(int providedMaxAttempts, @Nullable BackOff providedBackOff) {
        this.numberOfValuesToCreate = BackOffValuesGenerator.getMaxAttempts(providedMaxAttempts) - 1;
        this.backOff = providedBackOff != null ? providedBackOff : DEFAULT_BACKOFF;
    }

    private static int getMaxAttempts(int providedMaxAttempts) {
        return providedMaxAttempts != -1 ? providedMaxAttempts : 3;
    }

    public List<Long> generateValues() {
        BackOffExecution backOffExecution = this.backOff.start();
        return Stream.generate(() -> ((BackOffExecution)backOffExecution).nextBackOff()).limit(this.numberOfValuesToCreate).toList();
    }
}

