/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.jspecify.annotations.NonNull;
import org.springframework.kafka.support.micrometer.KafkaRecordSenderContext;
import org.springframework.kafka.support.micrometer.KafkaTemplateObservationConvention;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KafkaTemplateObservation implements ObservationDocumentation
{
    TEMPLATE_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultKafkaTemplateObservationConvention.class;
        }

        public @NonNull KeyName[] getLowCardinalityKeyNames() {
            return TemplateLowCardinalityTags.values();
        }
    };


    public static class DefaultKafkaTemplateObservationConvention
    implements KafkaTemplateObservationConvention {
        public static final DefaultKafkaTemplateObservationConvention INSTANCE = new DefaultKafkaTemplateObservationConvention();

        public KeyValues getLowCardinalityKeyValues(KafkaRecordSenderContext context) {
            return KeyValues.of((KeyValue[])new KeyValue[]{TemplateLowCardinalityTags.BEAN_NAME.withValue(context.getBeanName()), TemplateLowCardinalityTags.MESSAGING_SYSTEM.withValue("kafka"), TemplateLowCardinalityTags.MESSAGING_OPERATION.withValue("publish"), TemplateLowCardinalityTags.MESSAGING_DESTINATION_KIND.withValue("topic"), TemplateLowCardinalityTags.MESSAGING_DESTINATION_NAME.withValue(context.getDestination())});
        }

        public String getContextualName(KafkaRecordSenderContext context) {
            return context.getDestination() + " send";
        }

        @Override
        public @NonNull String getName() {
            return "spring.kafka.template";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TemplateLowCardinalityTags implements KeyName
    {
        BEAN_NAME{

            public @NonNull String asString() {
                return "spring.kafka.template.name";
            }
        }
        ,
        MESSAGING_SYSTEM{

            public @NonNull String asString() {
                return "messaging.system";
            }
        }
        ,
        MESSAGING_OPERATION{

            public @NonNull String asString() {
                return "messaging.operation";
            }
        }
        ,
        MESSAGING_DESTINATION_NAME{

            public @NonNull String asString() {
                return "messaging.destination.name";
            }
        }
        ,
        MESSAGING_DESTINATION_KIND{

            public @NonNull String asString() {
                return "messaging.destination.kind";
            }
        };

    }
}

