/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.support.micrometer.KafkaListenerObservationConvention;
import org.springframework.kafka.support.micrometer.KafkaRecordReceiverContext;
import org.springframework.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KafkaListenerObservation implements ObservationDocumentation
{
    LISTENER_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultKafkaListenerObservationConvention.class;
        }

        public @NonNull KeyName[] getLowCardinalityKeyNames() {
            return ListenerLowCardinalityTags.values();
        }

        public @NonNull KeyName[] getHighCardinalityKeyNames() {
            return ListenerHighCardinalityTags.values();
        }
    };


    public static class DefaultKafkaListenerObservationConvention
    implements KafkaListenerObservationConvention {
        public static final DefaultKafkaListenerObservationConvention INSTANCE = new DefaultKafkaListenerObservationConvention();

        public @NonNull KeyValues getLowCardinalityKeyValues(KafkaRecordReceiverContext context) {
            String groupId = context.getGroupId();
            KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{ListenerLowCardinalityTags.LISTENER_ID.withValue(context.getListenerId()), ListenerLowCardinalityTags.MESSAGING_SYSTEM.withValue("kafka"), ListenerLowCardinalityTags.MESSAGING_OPERATION.withValue("receive"), ListenerLowCardinalityTags.MESSAGING_SOURCE_NAME.withValue(context.getSource()), ListenerLowCardinalityTags.MESSAGING_SOURCE_KIND.withValue("topic")});
            if (StringUtils.hasText((String)groupId)) {
                keyValues = keyValues.and(new KeyValue[]{ListenerLowCardinalityTags.MESSAGING_CONSUMER_GROUP.withValue(groupId)});
            }
            return keyValues;
        }

        public @NonNull KeyValues getHighCardinalityKeyValues(KafkaRecordReceiverContext context) {
            String clientId = context.getClientId();
            String consumerId = DefaultKafkaListenerObservationConvention.getConsumerId(context.getGroupId(), clientId);
            KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{ListenerHighCardinalityTags.MESSAGING_PARTITION.withValue(context.getPartition()), ListenerHighCardinalityTags.MESSAGING_OFFSET.withValue(context.getOffset())});
            if (StringUtils.hasText((String)clientId)) {
                keyValues = keyValues.and(new KeyValue[]{ListenerHighCardinalityTags.MESSAGING_CLIENT_ID.withValue(clientId)});
            }
            if (StringUtils.hasText((String)consumerId)) {
                keyValues = keyValues.and(new KeyValue[]{ListenerHighCardinalityTags.MESSAGING_CONSUMER_ID.withValue(consumerId)});
            }
            return keyValues;
        }

        public String getContextualName(KafkaRecordReceiverContext context) {
            return context.getSource() + " receive";
        }

        private static @Nullable String getConsumerId(@Nullable String groupId, @Nullable String clientId) {
            if (StringUtils.hasText((String)groupId)) {
                if (StringUtils.hasText((String)clientId)) {
                    return groupId + " - " + clientId;
                }
                return groupId;
            }
            return clientId;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ListenerHighCardinalityTags implements KeyName
    {
        MESSAGING_CLIENT_ID{

            public @NonNull String asString() {
                return "messaging.kafka.client_id";
            }
        }
        ,
        MESSAGING_CONSUMER_ID{

            public @NonNull String asString() {
                return "messaging.consumer.id";
            }
        }
        ,
        MESSAGING_PARTITION{

            public @NonNull String asString() {
                return "messaging.kafka.source.partition";
            }
        }
        ,
        MESSAGING_OFFSET{

            public @NonNull String asString() {
                return "messaging.kafka.message.offset";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ListenerLowCardinalityTags implements KeyName
    {
        LISTENER_ID{

            public @NonNull String asString() {
                return "spring.kafka.listener.id";
            }
        }
        ,
        MESSAGING_SYSTEM{

            public @NonNull String asString() {
                return "messaging.system";
            }
        }
        ,
        MESSAGING_OPERATION{

            public @NonNull String asString() {
                return "messaging.operation";
            }
        }
        ,
        MESSAGING_SOURCE_NAME{

            public @NonNull String asString() {
                return "messaging.source.name";
            }
        }
        ,
        MESSAGING_SOURCE_KIND{

            public @NonNull String asString() {
                return "messaging.source.kind";
            }
        }
        ,
        MESSAGING_CONSUMER_GROUP{

            public @NonNull String asString() {
                return "messaging.kafka.consumer.group";
            }
        };

    }
}

