/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.support.AbstractKafkaHeaderMapper;
import org.springframework.kafka.support.JacksonUtils;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultKafkaHeaderMapper
extends AbstractKafkaHeaderMapper {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final Set<String> TRUSTED_ARRAY_TYPES = Set.of("[B", "[I", "[J", "[F", "[D", "[C");
    private static final List<String> DEFAULT_TRUSTED_PACKAGES = List.of("java.lang", "java.net", "java.util", "org.springframework.util");
    private static final List<String> DEFAULT_TO_STRING_CLASSES = List.of("org.springframework.util.MimeType", "org.springframework.http.MediaType");
    public static final String JSON_TYPES = "spring_json_header_types";
    private final ObjectMapper objectMapper;
    private final Set<String> trustedPackages = new LinkedHashSet<String>(DEFAULT_TRUSTED_PACKAGES);
    private final Set<String> toStringClasses = new LinkedHashSet<String>(DEFAULT_TO_STRING_CLASSES);
    private boolean encodeStrings;

    public DefaultKafkaHeaderMapper() {
        this(JacksonUtils.enhancedObjectMapper());
    }

    public DefaultKafkaHeaderMapper(ObjectMapper objectMapper) {
        this(objectMapper, "!id", "!timestamp", "*");
    }

    public DefaultKafkaHeaderMapper(String ... patterns) {
        this(JacksonUtils.enhancedObjectMapper(), patterns);
    }

    public DefaultKafkaHeaderMapper(ObjectMapper objectMapper, String ... patterns) {
        this(true, objectMapper, patterns);
    }

    private DefaultKafkaHeaderMapper(boolean outbound, ObjectMapper objectMapper, String ... patterns) {
        super(outbound, patterns);
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        Assert.noNullElements((Object[])patterns, (String)"'patterns' must not have null elements");
        this.objectMapper = objectMapper;
    }

    public static DefaultKafkaHeaderMapper forInboundOnlyWithMatchers(String ... patterns) {
        return new DefaultKafkaHeaderMapper(false, JacksonUtils.enhancedObjectMapper(), patterns);
    }

    public static DefaultKafkaHeaderMapper forInboundOnlyWithMatchers(ObjectMapper objectMapper, String ... patterns) {
        return new DefaultKafkaHeaderMapper(false, objectMapper, patterns);
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected Set<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    protected Set<String> getToStringClasses() {
        return this.toStringClasses;
    }

    protected boolean isEncodeStrings() {
        return this.encodeStrings;
    }

    public void setEncodeStrings(boolean encodeStrings) {
        this.encodeStrings = encodeStrings;
    }

    public void addTrustedPackages(String ... packagesToTrust) {
        if (packagesToTrust != null) {
            for (String trusted : packagesToTrust) {
                if ("*".equals(trusted)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(trusted);
            }
        }
    }

    public void addToStringClasses(String ... classNames) {
        this.toStringClasses.addAll(Arrays.asList(classNames));
    }

    @Override
    public void fromHeaders(MessageHeaders headers, Headers target) {
        HashMap jsonHeaders = new HashMap();
        ObjectMapper headerObjectMapper = this.getObjectMapper();
        headers.forEach((key, rawValue) -> {
            if (this.matches((String)key, rawValue)) {
                Object valueToAdd = this.headerValueToAddOut((String)key, rawValue);
                if (valueToAdd instanceof byte[]) {
                    target.add((Header)new RecordHeader(key, (byte[])valueToAdd));
                } else {
                    try {
                        String className = valueToAdd.getClass().getName();
                        boolean encodeToJson = this.encodeStrings;
                        if (this.toStringClasses.contains(className)) {
                            valueToAdd = valueToAdd.toString();
                            className = JAVA_LANG_STRING;
                            encodeToJson = true;
                        }
                        if (!encodeToJson && valueToAdd instanceof String) {
                            target.add((Header)new RecordHeader(key, ((String)valueToAdd).getBytes(this.getCharset())));
                        } else {
                            target.add((Header)new RecordHeader(key, headerObjectMapper.writeValueAsBytes(valueToAdd)));
                        }
                        jsonHeaders.put(key, className);
                    }
                    catch (Exception e) {
                        this.logger.error((Throwable)e, () -> "Could not map " + key + " with type " + rawValue.getClass().getName());
                    }
                }
            }
        });
        if (!jsonHeaders.isEmpty()) {
            try {
                target.add((Header)new RecordHeader(JSON_TYPES, headerObjectMapper.writeValueAsBytes(jsonHeaders)));
            }
            catch (JsonProcessingException | IllegalStateException e) {
                this.logger.error(e, (CharSequence)"Could not add json types header");
            }
        }
    }

    @Override
    public void toHeaders(Headers source, Map<String, Object> headers) {
        Map<String, String> jsonTypes = this.decodeJsonTypes(source);
        source.forEach(header -> {
            String headerName = header.key();
            if (headerName.equals("kafka_deliveryAttempt") && this.matchesForInbound(headerName)) {
                headers.put(headerName, ByteBuffer.wrap(header.value()).getInt());
            } else if (headerName.equals("kafka_listenerInfo") && this.matchesForInbound(headerName)) {
                headers.put(headerName, new String(header.value(), this.getCharset()));
            } else if (headerName.equals("springDeserializerExceptionKey") || headerName.equals("springDeserializerExceptionValue")) {
                headers.put(headerName, header);
            } else if (!headerName.equals(JSON_TYPES) && this.matchesForInbound(headerName)) {
                if (jsonTypes.containsKey(headerName)) {
                    String requestedType = (String)jsonTypes.get(headerName);
                    this.populateJsonValueHeader((Header)header, requestedType, headers);
                } else {
                    headers.put(headerName, this.headerValueToAddIn((Header)header));
                }
            }
        });
    }

    private void populateJsonValueHeader(Header header, String requestedType, Map<String, Object> headers) {
        Class type = Object.class;
        boolean trusted = false;
        try {
            trusted = this.trusted(requestedType);
            if (trusted) {
                type = ClassUtils.forName((String)requestedType, null);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, () -> "Could not load class for header: " + header.key());
        }
        if (String.class.equals((Object)type) && (header.value().length == 0 || header.value()[0] != 34)) {
            headers.put(header.key(), new String(header.value(), this.getCharset()));
        } else if (trusted) {
            try {
                Object value = this.decodeValue(header, type);
                headers.put(header.key(), value);
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, () -> "Could not decode json type: " + requestedType + " for key: " + header.key());
                headers.put(header.key(), header.value());
            }
        } else {
            headers.put(header.key(), new NonTrustedHeaderType(header.value(), requestedType));
        }
    }

    private Object decodeValue(Header h, Class<?> type) throws IOException, LinkageError {
        NonTrustedHeaderType nth;
        ObjectMapper headerObjectMapper = this.getObjectMapper();
        Object value = headerObjectMapper.readValue(h.value(), type);
        if (type.equals(NonTrustedHeaderType.class) && this.trusted((nth = (NonTrustedHeaderType)value).getUntrustedType())) {
            try {
                value = headerObjectMapper.readValue(nth.getHeaderValue(), ClassUtils.forName((String)nth.getUntrustedType(), null));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, () -> "Could not decode header: " + String.valueOf(nth));
            }
        }
        return value;
    }

    private Map<String, String> decodeJsonTypes(Headers source) {
        Map types = Collections.emptyMap();
        Header jsonTypes = source.lastHeader(JSON_TYPES);
        if (jsonTypes != null) {
            ObjectMapper headerObjectMapper = this.getObjectMapper();
            try {
                types = (Map)headerObjectMapper.readValue(jsonTypes.value(), (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, () -> "Could not decode json types: " + new String(jsonTypes.value(), StandardCharsets.UTF_8));
            }
        }
        return types;
    }

    protected boolean trusted(String requestedType) {
        String type;
        if (requestedType.equals(NonTrustedHeaderType.class.getName())) {
            return true;
        }
        if (TRUSTED_ARRAY_TYPES.contains(requestedType)) {
            return true;
        }
        String string = type = requestedType.startsWith("[") ? requestedType.substring(2) : requestedType;
        if (!this.trustedPackages.isEmpty()) {
            int lastDot = type.lastIndexOf(46);
            if (lastDot < 0) {
                return false;
            }
            String packageName = type.substring(0, lastDot);
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage) && !packageName.startsWith(trustedPackage + ".")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static class NonTrustedHeaderType {
        private byte[] headerValue;
        private String untrustedType;

        public NonTrustedHeaderType() {
        }

        NonTrustedHeaderType(byte[] headerValue, String untrustedType) {
            this.headerValue = headerValue;
            this.untrustedType = untrustedType;
        }

        public void setHeaderValue(byte[] headerValue) {
            this.headerValue = headerValue;
        }

        public byte[] getHeaderValue() {
            return this.headerValue;
        }

        public void setUntrustedType(String untrustedType) {
            this.untrustedType = untrustedType;
        }

        public String getUntrustedType() {
            return this.untrustedType;
        }

        public String toString() {
            try {
                return "NonTrustedHeaderType [headerValue=" + new String(this.headerValue, StandardCharsets.UTF_8) + ", untrustedType=" + this.untrustedType + "]";
            }
            catch (Exception e) {
                return "NonTrustedHeaderType [headerValue=" + Arrays.toString(this.headerValue) + ", untrustedType=" + this.untrustedType + "]";
            }
        }
    }
}

