/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.kafka.event.ListenerContainerIdleEvent;
import org.springframework.kafka.listener.ContainerGroup;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.kafka.listener.MessageListenerContainer;

public class ContainerGroupSequencer
implements ApplicationContextAware,
ApplicationListener<ListenerContainerIdleEvent>,
SmartLifecycle {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(ContainerGroupSequencer.class));
    private final ListenerContainerRegistry registry;
    private final long defaultIdleEventInterval;
    private final Collection<String> groupNames = new LinkedHashSet<String>();
    private final Collection<ContainerGroup> groups = new LinkedHashSet<ContainerGroup>();
    private final TaskExecutor executor = new SimpleAsyncTaskExecutor("container-group-sequencer-");
    private ApplicationContext applicationContext;
    private boolean stopLastGroupWhenIdle;
    private Iterator<ContainerGroup> iterator;
    private ContainerGroup currentGroup;
    private boolean autoStartup = true;
    private int phase = 2147483547;
    private boolean running;

    public ContainerGroupSequencer(ListenerContainerRegistry registry, long defaultIdleEventInterval, String ... containerGroups) {
        this.registry = registry;
        this.defaultIdleEventInterval = defaultIdleEventInterval;
        for (String groupName : containerGroups) {
            this.groupNames.add(groupName);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public synchronized void setStopLastGroupWhenIdle(boolean stopLastGroupWhenIdle) {
        this.stopLastGroupWhenIdle = stopLastGroupWhenIdle;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public synchronized void onApplicationEvent(ListenerContainerIdleEvent event) {
        boolean inCurrentGroup;
        LOGGER.debug(() -> event.toString());
        MessageListenerContainer parent = event.getContainer(MessageListenerContainer.class);
        MessageListenerContainer container = (MessageListenerContainer)event.getSource();
        boolean bl = inCurrentGroup = this.currentGroup != null && this.currentGroup.contains(parent);
        if (this.running && inCurrentGroup && (this.iterator.hasNext() || this.stopLastGroupWhenIdle)) {
            this.executor.execute(() -> {
                LOGGER.debug(() -> "Stopping: " + container);
                container.stop(() -> {
                    ContainerGroupSequencer containerGroupSequencer = this;
                    synchronized (containerGroupSequencer) {
                        if (!parent.isChildRunning()) {
                            this.executor.execute(() -> this.stopParentAndCheckGroup(parent));
                        }
                    }
                });
            });
        }
    }

    private synchronized void stopParentAndCheckGroup(MessageListenerContainer parent) {
        if (parent.isRunning()) {
            LOGGER.debug(() -> "Stopping: " + parent);
            parent.stop(() -> {
                if (this.currentGroup != null) {
                    LOGGER.debug(() -> "Checking group: " + this.currentGroup.toString());
                    if (this.currentGroup.allStopped()) {
                        if (this.iterator.hasNext()) {
                            this.currentGroup = this.iterator.next();
                            LOGGER.debug(() -> "Starting next group: " + this.currentGroup);
                            this.currentGroup.start();
                        } else {
                            this.currentGroup = null;
                        }
                    }
                }
            });
        }
    }

    public synchronized void start() {
        if (this.currentGroup != null) {
            LOGGER.debug(() -> "Starting first group: " + this.currentGroup);
            this.currentGroup.start();
        }
        this.running = true;
    }

    public void initialize() {
        this.groups.clear();
        for (String group : this.groupNames) {
            this.groups.add((ContainerGroup)this.applicationContext.getBean(group + ".group", ContainerGroup.class));
        }
        if (!this.groups.isEmpty()) {
            this.iterator = this.groups.iterator();
            this.currentGroup = this.iterator.next();
            this.groups.forEach(grp -> {
                Collection<String> ids = grp.getListenerIds();
                ids.stream().forEach(id -> {
                    MessageListenerContainer container = this.registry.getListenerContainer((String)id);
                    if (container.getContainerProperties().getIdleEventInterval() == null) {
                        container.getContainerProperties().setIdleEventInterval(this.defaultIdleEventInterval);
                        container.setAutoStartup(false);
                    }
                });
            });
        }
        LOGGER.debug(() -> "Found: " + this.groups);
    }

    public synchronized void stop() {
        this.running = false;
        if (this.currentGroup != null) {
            this.currentGroup.stop();
            this.currentGroup = null;
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }
}

