/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.support.KafkaUtils;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.kafka.support.serializer.DeserializationExceptionHeader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class SerializationUtils {
    public static final String DESERIALIZER_EXCEPTION_HEADER_PREFIX = "springDeserializerException";
    public static final String KEY_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionKey";
    public static final String VALUE_DESERIALIZER_EXCEPTION_HEADER = "springDeserializerExceptionValue";

    private SerializationUtils() {
    }

    public static <P, T> BiFunction<P, Headers, T> propertyToMethodInvokingFunction(String methodProperty, Class<P> payloadType, ClassLoader classLoader) {
        Method method;
        Class clazz;
        int lastDotPosn = methodProperty.lastIndexOf(46);
        Assert.state((lastDotPosn > 1 ? 1 : 0) != 0, (String)"the method property needs to be a class name followed by the method name, separated by '.'");
        try {
            clazz = ClassUtils.forName((String)methodProperty.substring(0, lastDotPosn), (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
        String methodName = methodProperty.substring(lastDotPosn + 1);
        try {
            method = clazz.getDeclaredMethod(methodName, payloadType, Headers.class);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getDeclaredMethod(methodName, payloadType);
            }
            catch (NoSuchMethodException e1) {
                IllegalStateException ise = new IllegalStateException("the parser method must take '(" + payloadType.getSimpleName() + ", Headers)' or '(" + payloadType.getSimpleName() + ")'", e1);
                ise.addSuppressed(e);
                throw ise;
            }
            catch (SecurityException e1) {
                IllegalStateException ise = new IllegalStateException(e1);
                ise.addSuppressed(e);
                throw ise;
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        Method parseMethod = method;
        BiFunction<Object, Headers, Object> function = method.getParameters().length > 1 ? (str, headers) -> {
            try {
                return parseMethod.invoke(null, str, headers);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        } : (str, headers) -> {
            try {
                return parseMethod.invoke(null, str);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
        return function;
    }

    public static void deserializationException(Headers headers, byte[] data, Exception ex, boolean isForKeyArg) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DeserializationException exception = new DeserializationException("failed to deserialize", data, isForKeyArg, ex);
        try (ObjectOutputStream oos = new ObjectOutputStream(stream);){
            oos.writeObject((Object)exception);
        }
        catch (IOException ioex) {
            stream = new ByteArrayOutputStream();
            try (ObjectOutputStream oos2 = new ObjectOutputStream(stream);){
                exception = new DeserializationException("failed to deserialize", data, isForKeyArg, new RuntimeException("Could not serialize type " + ex.getClass().getName() + " with message " + ioex.getMessage() + ". Original exception message: " + ex.getMessage()));
                oos2.writeObject((Object)exception);
            }
            catch (IOException ex2) {
                throw new IllegalStateException("Could not serialize a DeserializationException", ex2);
            }
        }
        headers.add((Header)new DeserializationExceptionHeader(isForKeyArg ? KEY_DESERIALIZER_EXCEPTION_HEADER : VALUE_DESERIALIZER_EXCEPTION_HEADER, stream.toByteArray()));
    }

    @Nullable
    public static DeserializationException getExceptionFromHeader(ConsumerRecord<?, ?> record, String headerName, LogAccessor logger) {
        Header header = record.headers().lastHeader(headerName);
        if (header != null && !(header instanceof DeserializationExceptionHeader)) {
            logger.warn(() -> String.format("Foreign deserialization exception header in (%s) ignored; possible attack?", KafkaUtils.format(record)));
            return null;
        }
        if (header != null) {
            DeserializationException exception = SerializationUtils.byteArrayToDeserializationException(logger, header);
            if (exception != null) {
                RecordHeaders headers = new RecordHeaders(record.headers().toArray());
                headers.remove(headerName);
                exception.setHeaders((Headers)headers);
            }
            return exception;
        }
        return null;
    }

    @Nullable
    public static DeserializationException byteArrayToDeserializationException(LogAccessor logger, Header header) {
        if (header != null && !(header instanceof DeserializationExceptionHeader)) {
            throw new IllegalStateException("Foreign deserialization exception header ignored; possible attack?");
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(header.value())){
                boolean first = true;

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (this.first) {
                        this.first = false;
                        Assert.state((boolean)desc.getName().equals(DeserializationException.class.getName()), (String)"Header does not contain a DeserializationException");
                    }
                    return super.resolveClass(desc);
                }
            };
            return (DeserializationException)((Object)ois.readObject());
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            logger.error((Throwable)e, (CharSequence)"Failed to deserialize a deserialization exception");
            return null;
        }
    }
}

