/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.TimestampedException;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultDestinationTopicResolver
extends ExceptionClassifier
implements DestinationTopicResolver,
ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private static final String NO_OPS_SUFFIX = "-noOps";
    private static final List<Class<? extends Throwable>> FRAMEWORK_EXCEPTIONS = Arrays.asList(ListenerExecutionFailedException.class, TimestampedException.class);
    private final Map<String, Map<String, DestinationTopicHolder>> sourceDestinationsHolderMap;
    private final Clock clock;
    private ApplicationContext applicationContext;
    private boolean contextRefreshed;

    @Deprecated(since="2.9", forRemoval=true)
    public DefaultDestinationTopicResolver(Clock clock, ApplicationContext applicationContext) {
        this(clock);
        this.applicationContext = applicationContext;
    }

    public DefaultDestinationTopicResolver(Clock clock) {
        this.clock = clock;
        this.sourceDestinationsHolderMap = new ConcurrentHashMap<String, Map<String, DestinationTopicHolder>>();
        this.contextRefreshed = false;
    }

    public DefaultDestinationTopicResolver() {
        this(Clock.systemUTC());
    }

    @Override
    public DestinationTopic resolveDestinationTopic(String mainListenerId, String topic, Integer attempt, Exception e, long originalTimestamp) {
        DestinationTopicHolder destinationTopicHolder = this.getDestinationHolderFor(mainListenerId, topic);
        return destinationTopicHolder.getSourceDestination().isDltTopic() ? this.handleDltProcessingFailure(destinationTopicHolder, e) : (destinationTopicHolder.getSourceDestination().shouldRetryOn(attempt, this.maybeUnwrapException(e)) && this.isNotFatalException(e) != false && !this.isPastTimout(originalTimestamp, destinationTopicHolder) ? this.resolveRetryDestination(destinationTopicHolder) : this.getDltOrNoOpsDestination(mainListenerId, topic));
    }

    private Boolean isNotFatalException(Exception e) {
        return this.getClassifier().classify((Throwable)e);
    }

    private Throwable maybeUnwrapException(Throwable e) {
        return FRAMEWORK_EXCEPTIONS.stream().filter(frameworkException -> frameworkException.isAssignableFrom(e.getClass())).map(frameworkException -> this.maybeUnwrapException(e.getCause())).findFirst().orElse(e);
    }

    private boolean isPastTimout(long originalTimestamp, DestinationTopicHolder destinationTopicHolder) {
        long timeout = destinationTopicHolder.getNextDestination().getDestinationTimeout();
        return timeout != -1L && Instant.now(this.clock).toEpochMilli() > originalTimestamp + timeout;
    }

    private DestinationTopic handleDltProcessingFailure(DestinationTopicHolder destinationTopicHolder, Exception e) {
        return destinationTopicHolder.getSourceDestination().isAlwaysRetryOnDltFailure() && this.isNotFatalException(e) != false ? destinationTopicHolder.getSourceDestination() : destinationTopicHolder.getNextDestination();
    }

    private DestinationTopic resolveRetryDestination(DestinationTopicHolder destinationTopicHolder) {
        return destinationTopicHolder.getSourceDestination().isReusableRetryTopic() || destinationTopicHolder.getSourceDestination().isSingleTopicRetry() ? destinationTopicHolder.getSourceDestination() : destinationTopicHolder.getNextDestination();
    }

    @Override
    public DestinationTopic getDestinationTopicByName(String mainListenerId, String topic) {
        Map<String, DestinationTopicHolder> map = this.sourceDestinationsHolderMap.get(mainListenerId);
        Assert.notNull(map, () -> "No destination resolution information for listener " + mainListenerId);
        return Objects.requireNonNull(map.get(topic), () -> "No DestinationTopic found for " + mainListenerId + ":" + topic).getSourceDestination();
    }

    @Override
    @Nullable
    public DestinationTopic getDltFor(String mainListenerId, String topicName) {
        DestinationTopic destination = this.getDltOrNoOpsDestination(mainListenerId, topicName);
        return destination.isNoOpsTopic() ? null : destination;
    }

    private DestinationTopic getDltOrNoOpsDestination(String mainListenerId, String topic) {
        DestinationTopic destination = this.getNextDestinationTopicFor(mainListenerId, topic);
        return destination.isDltTopic() || destination.isNoOpsTopic() ? destination : this.getDltOrNoOpsDestination(mainListenerId, destination.getDestinationName());
    }

    @Override
    public DestinationTopic getNextDestinationTopicFor(String mainListenerId, String topic) {
        return this.getDestinationHolderFor(mainListenerId, topic).getNextDestination();
    }

    private DestinationTopicHolder getDestinationHolderFor(String mainListenerId, String topic) {
        return this.contextRefreshed ? this.doGetDestinationFor(mainListenerId, topic) : this.getDestinationTopicSynchronized(mainListenerId, topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationTopicHolder getDestinationTopicSynchronized(String mainListenerId, String topic) {
        Map<String, Map<String, DestinationTopicHolder>> map = this.sourceDestinationsHolderMap;
        synchronized (map) {
            return this.doGetDestinationFor(mainListenerId, topic);
        }
    }

    private DestinationTopicHolder doGetDestinationFor(String mainListenerId, String topic) {
        Map<String, DestinationTopicHolder> map = this.sourceDestinationsHolderMap.get(mainListenerId);
        Assert.notNull(map, () -> "No destination resolution information for listener " + mainListenerId);
        return Objects.requireNonNull(map.get(topic), () -> "No destination found for topic: " + topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDestinationTopics(String mainListenerId, List<DestinationTopic> destinationsToAdd) {
        if (this.contextRefreshed) {
            throw new IllegalStateException("Cannot add new destinations, " + DefaultDestinationTopicResolver.class.getSimpleName() + " is already refreshed.");
        }
        this.validateDestinations(destinationsToAdd);
        Map<String, Map<String, DestinationTopicHolder>> map = this.sourceDestinationsHolderMap;
        synchronized (map) {
            Map map2 = this.sourceDestinationsHolderMap.computeIfAbsent(mainListenerId, id -> new HashMap());
            map2.putAll(this.correlatePairSourceAndDestinationValues(destinationsToAdd));
        }
    }

    private void validateDestinations(List<DestinationTopic> destinationsToAdd) {
        for (int i = 0; i < destinationsToAdd.size(); ++i) {
            DestinationTopic destination = destinationsToAdd.get(i);
            if (!destination.isReusableRetryTopic()) continue;
            Assert.isTrue((i == destinationsToAdd.size() - 1 || i == destinationsToAdd.size() - 2 && destinationsToAdd.get(i + 1).isDltTopic() ? 1 : 0) != 0, (String)String.format("In the destination topic chain, the type %s can only be specified as the last retry topic.", new Object[]{DestinationTopic.Type.REUSABLE_RETRY_TOPIC}));
        }
    }

    private Map<String, DestinationTopicHolder> correlatePairSourceAndDestinationValues(List<DestinationTopic> destinationList) {
        return IntStream.range(0, destinationList.size()).boxed().collect(Collectors.toMap(index -> ((DestinationTopic)destinationList.get((int)index)).getDestinationName(), index -> new DestinationTopicHolder((DestinationTopic)destinationList.get((int)index), this.getNextDestinationTopic(destinationList, (int)index))));
    }

    private DestinationTopic getNextDestinationTopic(List<DestinationTopic> destinationList, int index) {
        return index != destinationList.size() - 1 ? destinationList.get(index + 1) : new DestinationTopic(destinationList.get(index).getDestinationName() + NO_OPS_SUFFIX, destinationList.get(index), NO_OPS_SUFFIX, DestinationTopic.Type.NO_OPS);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (Objects.equals(event.getApplicationContext(), this.applicationContext)) {
            this.contextRefreshed = true;
        }
    }

    public boolean isContextRefreshed() {
        return this.contextRefreshed;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static class DestinationTopicHolder {
        private final DestinationTopic sourceDestination;
        private final DestinationTopic nextDestination;

        DestinationTopicHolder(DestinationTopic sourceDestination, DestinationTopic nextDestination) {
            this.sourceDestination = sourceDestination;
            this.nextDestination = nextDestination;
        }

        protected DestinationTopic getNextDestination() {
            return this.nextDestination;
        }

        protected DestinationTopic getSourceDestination() {
            return this.sourceDestination;
        }
    }
}

