/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.KafkaUtils;

public class CommonLoggingErrorHandler
implements CommonErrorHandler {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(CommonLoggingErrorHandler.class));
    private boolean ackAfterHandle = true;

    @Override
    public boolean isAckAfterHandle() {
        return this.ackAfterHandle;
    }

    @Override
    public void setAckAfterHandle(boolean ackAfterHandle) {
        this.ackAfterHandle = ackAfterHandle;
    }

    @Override
    public boolean handleOne(Exception thrownException, ConsumerRecord<?, ?> record, Consumer<?, ?> consumer, MessageListenerContainer container) {
        LOGGER.error((Throwable)thrownException, () -> "Error occured while processing: " + KafkaUtils.format(record));
        return true;
    }

    @Override
    public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        StringBuilder message = new StringBuilder("Error occurred while processing:\n");
        for (ConsumerRecord record : data) {
            message.append(KafkaUtils.format(record)).append('\n');
        }
        LOGGER.error((Throwable)thrownException, () -> message.substring(0, message.length() - 1));
    }

    @Override
    public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        LOGGER.error((Throwable)thrownException, () -> "Error occurred while not processing records");
    }
}

