/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.KafkaOperations2;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.SendResult;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.concurrent.ListenableFuture;

public interface KafkaOperations<K, V> {
    public static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofSeconds(5L);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> sendDefault(V var1);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> sendDefault(K var1, V var2);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> sendDefault(Integer var1, K var2, V var3);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> sendDefault(Integer var1, Long var2, K var3, V var4);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> send(String var1, V var2);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> send(String var1, K var2, V var3);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> send(String var1, Integer var2, K var3, V var4);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> send(String var1, Integer var2, Long var3, K var4, V var5);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> send(ProducerRecord<K, V> var1);

    @Deprecated
    public ListenableFuture<SendResult<K, V>> send(Message<?> var1);

    public List<PartitionInfo> partitionsFor(String var1);

    public Map<MetricName, ? extends Metric> metrics();

    @Nullable
    public <T> T execute(ProducerCallback<K, V, T> var1);

    @Nullable
    public <T> T executeInTransaction(OperationsCallback<K, V, T> var1);

    public void flush();

    @Deprecated
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1);

    @Deprecated
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> var1, String var2);

    default public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
        throw new UnsupportedOperationException();
    }

    public boolean isTransactional();

    default public boolean isAllowNonTransactional() {
        return false;
    }

    default public boolean inTransaction() {
        return false;
    }

    default public ProducerFactory<K, V> getProducerFactory() {
        throw new UnsupportedOperationException("This implementation does not support this operation");
    }

    @Nullable
    default public ConsumerRecord<K, V> receive(String topic, int partition, long offset) {
        return this.receive(topic, partition, offset, DEFAULT_POLL_TIMEOUT);
    }

    @Nullable
    public ConsumerRecord<K, V> receive(String var1, int var2, long var3, Duration var5);

    default public ConsumerRecords<K, V> receive(Collection<TopicPartitionOffset> requested) {
        return this.receive(requested, DEFAULT_POLL_TIMEOUT);
    }

    public ConsumerRecords<K, V> receive(Collection<TopicPartitionOffset> var1, Duration var2);

    default public KafkaOperations2<K, V> usingCompletableFuture() {
        return new KafkaOperations2<K, V>(){

            @Override
            public CompletableFuture<SendResult<K, V>> sendDefault(V data) {
                return KafkaOperations.this.sendDefault(data).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> sendDefault(K key, V data) {
                return KafkaOperations.this.sendDefault(key, data).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> sendDefault(Integer partition, K key, V data) {
                return KafkaOperations.this.sendDefault(partition, key, data).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> sendDefault(Integer partition, Long timestamp, K key, V data) {
                return KafkaOperations.this.sendDefault(partition, timestamp, key, data).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> send(String topic, V data) {
                return KafkaOperations.this.send(topic, data).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> send(String topic, K key, V data) {
                return KafkaOperations.this.send(topic, key, data).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> send(String topic, Integer partition, K key, V data) {
                return KafkaOperations.this.send(topic, partition, key, data).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> send(String topic, Integer partition, Long timestamp, K key, V data) {
                return KafkaOperations.this.send(topic, partition, timestamp, key, data).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> send(ProducerRecord<K, V> record) {
                return KafkaOperations.this.send(record).completable();
            }

            @Override
            public CompletableFuture<SendResult<K, V>> send(Message<?> message) {
                return KafkaOperations.this.send(message).completable();
            }

            @Override
            public List<PartitionInfo> partitionsFor(String topic) {
                return KafkaOperations.this.partitionsFor(topic);
            }

            @Override
            public Map<MetricName, ? extends Metric> metrics() {
                return KafkaOperations.this.metrics();
            }

            @Override
            @Nullable
            public <T> T execute(ProducerCallback<K, V, T> callback) {
                return KafkaOperations.this.execute(callback);
            }

            @Override
            @Nullable
            public <T> T executeInTransaction(OperationsCallback<K, V, T> callback) {
                return KafkaOperations.this.executeInTransaction(callback);
            }

            @Override
            public void flush() {
                KafkaOperations.this.flush();
            }

            @Override
            public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
                KafkaOperations.this.sendOffsetsToTransaction(offsets, groupMetadata);
            }

            @Override
            public boolean isTransactional() {
                return KafkaOperations.this.isTransactional();
            }

            @Override
            public boolean isAllowNonTransactional() {
                return KafkaOperations.this.isAllowNonTransactional();
            }

            @Override
            public boolean inTransaction() {
                return KafkaOperations.this.inTransaction();
            }

            @Override
            public ProducerFactory<K, V> getProducerFactory() {
                return KafkaOperations.this.getProducerFactory();
            }

            @Override
            @Nullable
            public ConsumerRecord<K, V> receive(String topic, int partition, long offset) {
                return KafkaOperations.this.receive(topic, partition, offset);
            }

            @Override
            @Nullable
            public ConsumerRecord<K, V> receive(String topic, int partition, long offset, Duration pollTimeout) {
                return KafkaOperations.this.receive(topic, partition, offset, pollTimeout);
            }

            @Override
            public ConsumerRecords<K, V> receive(Collection<TopicPartitionOffset> requested) {
                return KafkaOperations.this.receive(requested);
            }

            @Override
            public ConsumerRecords<K, V> receive(Collection<TopicPartitionOffset> requested, Duration pollTimeout) {
                return KafkaOperations.this.receive(requested, pollTimeout);
            }
        };
    }

    public static interface OperationsCallback<K, V, T> {
        public T doInOperations(KafkaOperations<K, V> var1);
    }

    public static interface ProducerCallback<K, V, T> {
        public T doInKafka(Producer<K, V> var1);
    }
}

