/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.requestreply;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

public class RequestReplyFuture<K, V, R>
extends SettableListenableFuture<ConsumerRecord<K, R>> {
    private volatile ListenableFuture<SendResult<K, V>> sendFuture;
    private CompletableFuture<SendResult<K, V>> completableSendFuture;
    private Completable completable;

    protected void setSendFuture(ListenableFuture<SendResult<K, V>> sendFuture) {
        this.sendFuture = sendFuture;
    }

    public ListenableFuture<SendResult<K, V>> getSendFuture() {
        return this.sendFuture;
    }

    public synchronized Completable asCompletable() {
        if (this.completable == null) {
            this.completable = new Completable(this);
            this.addCallback(this.completable::complete, this.completable::completeExceptionally);
        }
        return this.completable;
    }

    public class Completable
    extends CompletableFuture<ConsumerRecord<K, R>> {
        private final Future<ConsumerRecord<K, R>> delegate;

        Completable(Future<ConsumerRecord<K, R>> delegate) {
            Assert.notNull(delegate, (String)"Delegate must not be null");
            this.delegate = delegate;
        }

        public synchronized CompletableFuture<SendResult<K, V>> getSendFuture() {
            if (RequestReplyFuture.this.completableSendFuture == null) {
                RequestReplyFuture.this.completableSendFuture = RequestReplyFuture.this.sendFuture.completable();
            }
            return RequestReplyFuture.this.completableSendFuture;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = this.delegate.cancel(mayInterruptIfRunning);
            super.cancel(mayInterruptIfRunning);
            return result;
        }
    }
}

