/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;

public final class ErrorHandlingUtils {
    private ErrorHandlingUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void retryBatch(Exception thrownException, ConsumerRecords<?, ?> records, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener, BackOff backOff, CommonErrorHandler seeker, BiConsumer<ConsumerRecords<?, ?>, Exception> recoverer, LogAccessor logger, KafkaException.Level logLevel) {
        BackOffExecution execution = backOff.start();
        long nextBackOff = execution.nextBackOff();
        String failed = null;
        Set assignment = consumer.assignment();
        consumer.pause((Collection)assignment);
        if (container instanceof KafkaMessageListenerContainer) {
            ((KafkaMessageListenerContainer)container).publishConsumerPausedEvent(assignment, "For batch retry");
        }
        while (nextBackOff != -1L) {
            consumer.poll(Duration.ZERO);
            try {
                ListenerUtils.stoppableSleep(container, nextBackOff);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                seeker.handleBatch(thrownException, records, consumer, container, () -> {});
                throw new KafkaException("Interrupted during retry", logLevel, e1);
            }
            if (!container.isRunning()) {
                throw new KafkaException("Container stopped during retries");
            }
            try {
                invokeListener.run();
                return;
            }
            catch (Exception e) {
                if (failed == null) {
                    failed = ErrorHandlingUtils.recordsToString(records);
                }
                String toLog = failed;
                logger.debug((Throwable)e, () -> "Retry failed for: " + toLog);
                nextBackOff = execution.nextBackOff();
            }
        }
        recoverer.accept(records, thrownException);
        return;
        catch (Exception e) {
            logger.error((Throwable)e, () -> "Recoverer threw an exception; re-seeking batch");
            seeker.handleBatch(thrownException, records, consumer, container, () -> {});
            return;
        }
        finally {
            Set assignment2 = consumer.assignment();
            consumer.resume((Collection)assignment2);
            if (container instanceof KafkaMessageListenerContainer) {
                ((KafkaMessageListenerContainer)container).publishConsumerResumedEvent(assignment2);
            }
        }
    }

    public static String recordsToString(ConsumerRecords<?, ?> records) {
        StringBuffer sb = new StringBuffer();
        records.spliterator().forEachRemaining(rec -> sb.append(ListenerUtils.recordToString(rec, true)).append(','));
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

