/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerPartitionPausingBackOffManagerFactory;
import org.springframework.kafka.listener.ContainerPausingBackOffHandler;
import org.springframework.kafka.listener.DeadLetterPublishingRecoverer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.listener.ExceptionClassifier;
import org.springframework.kafka.listener.KafkaBackOffManagerFactory;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.kafka.listener.ListenerContainerPauseService;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.kafka.retrytopic.DeadLetterPublishingRecovererFactory;
import org.springframework.kafka.retrytopic.DefaultDestinationTopicResolver;
import org.springframework.kafka.retrytopic.DestinationTopicProcessor;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryConfigurer;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryResolver;
import org.springframework.kafka.retrytopic.RetryTopicComponentFactory;
import org.springframework.kafka.retrytopic.RetryTopicConfigurer;
import org.springframework.kafka.retrytopic.RetryTopicNamesProviderFactory;
import org.springframework.kafka.retrytopic.RetryTopicSchedulerWrapper;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;

public class RetryTopicConfigurationSupport {
    private static final AtomicBoolean ONLY_ONE_ALLOWED = new AtomicBoolean(true);
    private final RetryTopicComponentFactory componentFactory = this.createComponentFactory();

    public RetryTopicConfigurationSupport() {
        Assert.state((boolean)ONLY_ONE_ALLOWED.getAndSet(false), (String)"Only one 'RetryTopicConfigurationSupport' is allowed");
    }

    @Bean(name={"org.springframework.kafka.retrytopic.internalRetryTopicConfigurer"})
    public RetryTopicConfigurer retryTopicConfigurer(@Qualifier(value="org.springframework.kafka.config.internalKafkaConsumerBackOffManager") KafkaConsumerBackoffManager kafkaConsumerBackoffManager, @Qualifier(value="org.springframework.kafka.retrytopic.internalDestinationTopicResolver") DestinationTopicResolver destinationTopicResolver, BeanFactory beanFactory) {
        DestinationTopicProcessor destinationTopicProcessor = this.componentFactory.destinationTopicProcessor(destinationTopicResolver);
        DeadLetterPublishingRecovererFactory dlprf = this.componentFactory.deadLetterPublishingRecovererFactory(destinationTopicResolver);
        ListenerContainerFactoryConfigurer lcfc = this.componentFactory.listenerContainerFactoryConfigurer(kafkaConsumerBackoffManager, dlprf, this.componentFactory.internalRetryTopicClock());
        ListenerContainerFactoryResolver factoryResolver = this.componentFactory.listenerContainerFactoryResolver(beanFactory);
        RetryTopicNamesProviderFactory retryTopicNamesProviderFactory = this.componentFactory.retryTopicNamesProviderFactory();
        this.processDeadLetterPublishingContainerFactory(dlprf);
        this.processListenerContainerFactoryConfigurer(lcfc);
        RetryTopicConfigurer retryTopicConfigurer = this.componentFactory.retryTopicConfigurer(destinationTopicProcessor, lcfc, factoryResolver, retryTopicNamesProviderFactory);
        Consumer<RetryTopicConfigurer> configurerConsumer = this.configureRetryTopicConfigurer();
        Assert.notNull(configurerConsumer, (String)"configureRetryTopicConfigurer cannot return null.");
        configurerConsumer.accept(retryTopicConfigurer);
        return retryTopicConfigurer;
    }

    protected Consumer<RetryTopicConfigurer> configureRetryTopicConfigurer() {
        return retryTopicConfigurer -> {};
    }

    private void processDeadLetterPublishingContainerFactory(DeadLetterPublishingRecovererFactory deadLetterPublishingRecovererFactory) {
        CustomizersConfigurer customizersConfigurer = new CustomizersConfigurer();
        this.configureCustomizers(customizersConfigurer);
        JavaUtils.INSTANCE.acceptIfNotNull(customizersConfigurer.deadLetterPublishingRecovererCustomizer, deadLetterPublishingRecovererFactory::setDeadLetterPublishingRecovererCustomizer);
        Consumer<DeadLetterPublishingRecovererFactory> dlprfConsumer = this.configureDeadLetterPublishingContainerFactory();
        Assert.notNull(dlprfConsumer, (String)"configureDeadLetterPublishingContainerFactory must not return null");
        dlprfConsumer.accept(deadLetterPublishingRecovererFactory);
    }

    protected Consumer<DeadLetterPublishingRecovererFactory> configureDeadLetterPublishingContainerFactory() {
        return dlprf -> {};
    }

    private void processListenerContainerFactoryConfigurer(ListenerContainerFactoryConfigurer listenerContainerFactoryConfigurer) {
        CustomizersConfigurer customizersConfigurer = new CustomizersConfigurer();
        this.configureCustomizers(customizersConfigurer);
        BlockingRetriesConfigurer blockingRetriesConfigurer = new BlockingRetriesConfigurer();
        this.configureBlockingRetries(blockingRetriesConfigurer);
        JavaUtils.INSTANCE.acceptIfNotNull(blockingRetriesConfigurer.backOff, listenerContainerFactoryConfigurer::setBlockingRetriesBackOff).acceptIfNotNull(blockingRetriesConfigurer.retryableExceptions, listenerContainerFactoryConfigurer::setBlockingRetryableExceptions).acceptIfNotNull(customizersConfigurer.errorHandlerCustomizer, listenerContainerFactoryConfigurer::setErrorHandlerCustomizer).acceptIfNotNull(customizersConfigurer.listenerContainerCustomizer, listenerContainerFactoryConfigurer::setContainerCustomizer);
        Consumer<ListenerContainerFactoryConfigurer> lcfcConfigurer = this.configureListenerContainerFactoryConfigurer();
        Assert.notNull(lcfcConfigurer, (String)"configureListenerContainerFactoryConfigurer must not return null.");
        lcfcConfigurer.accept(listenerContainerFactoryConfigurer);
    }

    protected Consumer<ListenerContainerFactoryConfigurer> configureListenerContainerFactoryConfigurer() {
        return lcfc -> {};
    }

    protected void configureBlockingRetries(BlockingRetriesConfigurer blockingRetries) {
    }

    protected void manageNonBlockingFatalExceptions(List<Class<? extends Throwable>> nonBlockingRetriesExceptions) {
    }

    protected void configureCustomizers(CustomizersConfigurer customizersConfigurer) {
    }

    @Bean(name={"org.springframework.kafka.retrytopic.internalDestinationTopicResolver"})
    public DestinationTopicResolver destinationTopicResolver() {
        DestinationTopicResolver destinationTopicResolver = this.componentFactory.destinationTopicResolver();
        JavaUtils.INSTANCE.acceptIfInstanceOf(DefaultDestinationTopicResolver.class, destinationTopicResolver, this::configureNonBlockingFatalExceptions);
        Consumer<DestinationTopicResolver> resolverConsumer = this.configureDestinationTopicResolver();
        Assert.notNull(resolverConsumer, (String)"customizeDestinationTopicResolver must not return null");
        resolverConsumer.accept(destinationTopicResolver);
        return destinationTopicResolver;
    }

    private void configureNonBlockingFatalExceptions(DefaultDestinationTopicResolver destinationTopicResolver) {
        ArrayList<Class<? extends Throwable>> fatalExceptions = new ArrayList<Class<? extends Throwable>>(ExceptionClassifier.defaultFatalExceptionsList());
        this.manageNonBlockingFatalExceptions(fatalExceptions);
        destinationTopicResolver.setClassifications(fatalExceptions.stream().collect(Collectors.toMap(ex -> ex, ex -> false)), true);
    }

    protected Consumer<DestinationTopicResolver> configureDestinationTopicResolver() {
        return dtr -> {};
    }

    @Bean(name={"org.springframework.kafka.config.internalKafkaConsumerBackOffManager"})
    public KafkaConsumerBackoffManager kafkaConsumerBackoffManager(ApplicationContext applicationContext, @Qualifier(value="org.springframework.kafka.config.internalKafkaListenerEndpointRegistry") ListenerContainerRegistry registry, @Nullable RetryTopicSchedulerWrapper wrapper, @Nullable TaskScheduler taskScheduler) {
        KafkaBackOffManagerFactory backOffManagerFactory = this.componentFactory.kafkaBackOffManagerFactory(registry, applicationContext);
        JavaUtils.INSTANCE.acceptIfInstanceOf(ContainerPartitionPausingBackOffManagerFactory.class, backOffManagerFactory, factory -> this.configurePartitionPausingFactory((ContainerPartitionPausingBackOffManagerFactory)factory, registry, wrapper != null ? wrapper.getScheduler() : taskScheduler));
        return backOffManagerFactory.create();
    }

    private void configurePartitionPausingFactory(ContainerPartitionPausingBackOffManagerFactory factory, ListenerContainerRegistry registry, @Nullable TaskScheduler scheduler) {
        Assert.notNull((Object)scheduler, (String)"Either a RetryTopicSchedulerWrapper or TaskScheduler bean is required");
        factory.setBackOffHandler(new ContainerPausingBackOffHandler(new ListenerContainerPauseService(registry, scheduler)));
    }

    protected RetryTopicComponentFactory createComponentFactory() {
        return new RetryTopicComponentFactory();
    }

    public static class CustomizersConfigurer {
        private Consumer<DefaultErrorHandler> errorHandlerCustomizer;
        private Consumer<ConcurrentMessageListenerContainer<?, ?>> listenerContainerCustomizer;
        private Consumer<DeadLetterPublishingRecoverer> deadLetterPublishingRecovererCustomizer;

        public CustomizersConfigurer customizeErrorHandler(Consumer<DefaultErrorHandler> errorHandlerCustomizer) {
            this.errorHandlerCustomizer = errorHandlerCustomizer;
            return this;
        }

        public CustomizersConfigurer customizeListenerContainer(Consumer<ConcurrentMessageListenerContainer<?, ?>> listenerContainerCustomizer) {
            this.listenerContainerCustomizer = listenerContainerCustomizer;
            return this;
        }

        public CustomizersConfigurer customizeDeadLetterPublishingRecoverer(Consumer<DeadLetterPublishingRecoverer> dlprCustomizer) {
            this.deadLetterPublishingRecovererCustomizer = dlprCustomizer;
            return this;
        }
    }

    public static class BlockingRetriesConfigurer {
        private BackOff backOff;
        private Class<? extends Exception>[] retryableExceptions;

        @SafeVarargs
        public final BlockingRetriesConfigurer retryOn(Class<? extends Exception> ... exceptions) {
            this.retryableExceptions = Arrays.copyOf(exceptions, exceptions.length);
            return this;
        }

        public BlockingRetriesConfigurer backOff(BackOff backoff) {
            this.backOff = backoff;
            return this;
        }
    }
}

